/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.EmptySubscription;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class TakeWhilePublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private static final PublisherSource.Subscription CANCELLED = new EmptySubscription();
    private final Predicate<? super T> predicate;

    TakeWhilePublisher(Publisher<T> original, Predicate<? super T> predicate, Executor executor) {
        super(original, executor);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new TakeWhileSubscriber<T>(subscriber, this.predicate);
    }

    private static final class TakeWhileSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final Predicate<? super T> predicate;
        @Nullable
        private PublisherSource.Subscription subscription;

        TakeWhileSubscriber(PublisherSource.Subscriber<? super T> subscriber, Predicate<? super T> predicate) {
            this.subscriber = subscriber;
            this.predicate = predicate;
        }

        public void onSubscribe(PublisherSource.Subscription s) {
            if (SubscriberUtils.checkDuplicateSubscription((PublisherSource.Subscription)this.subscription, (PublisherSource.Subscription)s)) {
                this.subscription = ConcurrentSubscription.wrap((PublisherSource.Subscription)s);
                this.subscriber.onSubscribe(this.subscription);
            }
        }

        public void onNext(T t) {
            PublisherSource.Subscription subscription = this.subscription;
            assert (subscription != null) : "Subscription can not be null.";
            if (subscription == CANCELLED) {
                return;
            }
            if (!this.predicate.test(t)) {
                this.subscription = CANCELLED;
                subscription.cancel();
                this.subscriber.onComplete();
            } else {
                this.subscriber.onNext(t);
            }
        }

        public void onError(Throwable t) {
            if (this.subscription != CANCELLED) {
                this.subscriber.onError(t);
            }
        }

        public void onComplete() {
            if (this.subscription != CANCELLED) {
                this.subscriber.onComplete();
            }
        }
    }
}

