/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractSynchronousSingle;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SucceededSingle<T>
extends AbstractSynchronousSingle<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SucceededSingle.class);
    @Nullable
    private final T value;

    SucceededSingle(@Nullable T value) {
        this.value = value;
    }

    @Override
    void doSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        try {
            subscriber.onSubscribe(Cancellable.IGNORE_CANCEL);
        }
        catch (Throwable t) {
            SubscriberUtils.handleExceptionFromOnSubscribe(subscriber, (Throwable)t);
            return;
        }
        try {
            subscriber.onSuccess(this.value);
        }
        catch (Throwable t) {
            LOGGER.info("Ignoring exception from onSuccess of Subscriber {}.", subscriber, (Object)t);
        }
    }
}

