/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.ConcurrentUtils;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.QueueFullAndRejectedSubscribeException;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class SingleProcessor<T>
extends Single<T>
implements SingleSource.Processor<T, T> {
    private static final AtomicReferenceFieldUpdater<SingleProcessor, Object> terminalSignalUpdater = AtomicReferenceFieldUpdater.newUpdater(SingleProcessor.class, Object.class, "terminalSignal");
    private static final AtomicIntegerFieldUpdater<SingleProcessor> drainingTheQueueUpdater = AtomicIntegerFieldUpdater.newUpdater(SingleProcessor.class, "drainingTheQueue");
    private static final Object TERMINAL_NULL = new Object();
    private final Queue<SingleSource.Subscriber<? super T>> subscribers = PlatformDependent.newUnboundedLinkedMpscQueue();
    @Nullable
    private volatile Object terminalSignal = TERMINAL_NULL;
    private volatile int drainingTheQueue;

    SingleProcessor() {
    }

    @Override
    protected void handleSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        DelayedCancellable delayedCancellable = new DelayedCancellable();
        subscriber.onSubscribe((Cancellable)delayedCancellable);
        if (this.subscribers.offer(subscriber)) {
            Object terminalSignal = this.terminalSignal;
            if (terminalSignal != TERMINAL_NULL) {
                this.notifyListeners(terminalSignal);
            } else {
                delayedCancellable.delayedCancellable(() -> {
                    if (!drainingTheQueueUpdater.compareAndSet(this, 0, 1)) {
                        return;
                    }
                    try {
                        this.subscribers.remove(subscriber);
                    }
                    finally {
                        drainingTheQueueUpdater.set(this, 0);
                    }
                    Object terminalSignal2 = this.terminalSignal;
                    if (terminalSignal2 != TERMINAL_NULL) {
                        this.notifyListeners(terminalSignal2);
                    }
                });
            }
        } else {
            subscriber.onError((Throwable)new QueueFullAndRejectedSubscribeException("subscribers"));
        }
    }

    public void onSubscribe(Cancellable cancellable) {
    }

    public void onSuccess(@Nullable T result) {
        this.terminate(result);
    }

    public void onError(Throwable t) {
        this.terminate(TerminalNotification.error((Throwable)t));
    }

    private void terminate(@Nullable Object terminalSignal) {
        if (terminalSignalUpdater.compareAndSet(this, TERMINAL_NULL, terminalSignal)) {
            this.notifyListeners(terminalSignal);
        }
    }

    private void notifyListeners(@Nullable Object terminalSignal) {
        if (terminalSignal instanceof TerminalNotification) {
            Throwable error = ((TerminalNotification)terminalSignal).cause();
            assert (error != null) : "Cause can't be null from TerminalNotification.error(..)";
            ConcurrentUtils.drainSingleConsumerQueueDelayThrow(this.subscribers, subscriber -> subscriber.onError(error), drainingTheQueueUpdater, (Object)this);
        } else {
            Object value = terminalSignal;
            ConcurrentUtils.drainSingleConsumerQueueDelayThrow(this.subscribers, subscriber -> subscriber.onSuccess(value), drainingTheQueueUpdater, (Object)this);
        }
    }

    public void subscribe(SingleSource.Subscriber<? super T> subscriber) {
        this.subscribeInternal(subscriber);
    }
}

