/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public final class RetryStrategies {
    private RetryStrategies() {
    }

    public static BiIntFunction<Throwable, Completable> retryWithConstantBackoff(int maxRetries, Predicate<Throwable> causeFilter, Duration delay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRetries);
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long delayNanos = delay.toNanos();
        return (retryCount, cause) -> {
            if (retryCount > maxRetries || !causeFilter.test((Throwable)cause)) {
                return Completable.failed(cause);
            }
            return timerExecutor.timer(delayNanos, TimeUnit.NANOSECONDS);
        };
    }

    public static BiIntFunction<Throwable, Completable> retryWithConstantBackoffAndJitter(int maxRetries, Predicate<Throwable> causeFilter, Duration delay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRetries);
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long delayNanos = delay.toNanos();
        return (retryCount, cause) -> {
            if (retryCount > maxRetries || !causeFilter.test((Throwable)cause)) {
                return Completable.failed(cause);
            }
            return timerExecutor.timer(ThreadLocalRandom.current().nextLong(0L, delayNanos), TimeUnit.NANOSECONDS);
        };
    }

    public static BiIntFunction<Throwable, Completable> retryWithExponentialBackoff(int maxRetries, Predicate<Throwable> causeFilter, Duration initialDelay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRetries);
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long initialDelayNanos = initialDelay.toNanos();
        return (retryCount, cause) -> {
            if (retryCount > maxRetries || !causeFilter.test((Throwable)cause)) {
                return Completable.failed(cause);
            }
            return timerExecutor.timer(initialDelayNanos << retryCount - 1, TimeUnit.NANOSECONDS);
        };
    }

    public static BiIntFunction<Throwable, Completable> retryWithExponentialBackoffAndJitter(int maxRetries, Predicate<Throwable> causeFilter, Duration initialDelay, Executor timerExecutor) {
        RetryStrategies.checkMaxRetries(maxRetries);
        Objects.requireNonNull(timerExecutor);
        Objects.requireNonNull(causeFilter);
        long initialDelayNanos = initialDelay.toNanos();
        return (retryCount, cause) -> {
            if (retryCount > maxRetries || !causeFilter.test((Throwable)cause)) {
                return Completable.failed(cause);
            }
            return timerExecutor.timer(ThreadLocalRandom.current().nextLong(0L, initialDelayNanos << retryCount - 1), TimeUnit.NANOSECONDS);
        };
    }

    private static void checkMaxRetries(int maxRetries) {
        if (maxRetries <= 0) {
            throw new IllegalArgumentException("maxRetries: " + maxRetries + " (expected: >0)");
        }
    }
}

