/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;

public final class RepeatStrategies {
    private RepeatStrategies() {
    }

    public static IntFunction<Completable> repeatWithConstantBackoff(int maxRepeats, Duration backoff, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        long backoffNanos = backoff.toNanos();
        return repeatCount -> {
            if (repeatCount > maxRepeats) {
                return RepeatStrategies.terminateRepeat();
            }
            return timerExecutor.timer(backoffNanos, TimeUnit.NANOSECONDS);
        };
    }

    public static IntFunction<Completable> repeatWithExponentialBackoff(int maxRepeats, Duration initialDelay, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        long initialDelayNanos = initialDelay.toNanos();
        return repeatCount -> {
            if (repeatCount > maxRepeats) {
                return RepeatStrategies.terminateRepeat();
            }
            return timerExecutor.timer(initialDelayNanos << repeatCount - 1, TimeUnit.NANOSECONDS);
        };
    }

    public static IntFunction<Completable> repeatWithExponentialBackoffAndJitter(int maxRepeats, Duration initialDelay, Executor timerExecutor) {
        Objects.requireNonNull(timerExecutor);
        long initialDelayNanos = initialDelay.toNanos();
        return repeatCount -> {
            if (repeatCount > maxRepeats) {
                return RepeatStrategies.terminateRepeat();
            }
            return timerExecutor.timer(ThreadLocalRandom.current().nextLong(0L, initialDelayNanos << repeatCount - 1), TimeUnit.NANOSECONDS);
        };
    }

    private static Completable terminateRepeat() {
        return Completable.failed(TerminateRepeatException.INSTANCE);
    }

    public static final class TerminateRepeatException
    extends Exception {
        private static final long serialVersionUID = -1725458427890873886L;
        static final TerminateRepeatException INSTANCE = new TerminateRepeatException();

        private TerminateRepeatException() {
            super(null, null, false, false);
        }
    }
}

