/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.DynamicCompositeCancellable;
import io.servicetalk.concurrent.internal.ConcurrentUtils;
import io.servicetalk.concurrent.internal.QueueFullException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class QueueDynamicCompositeCancellable
implements DynamicCompositeCancellable {
    private static final AtomicIntegerFieldUpdater<QueueDynamicCompositeCancellable> cancelledUpdater = AtomicIntegerFieldUpdater.newUpdater(QueueDynamicCompositeCancellable.class, "cancelled");
    private volatile int cancelled;
    private static final AtomicIntegerFieldUpdater<QueueDynamicCompositeCancellable> drainingUpdater = AtomicIntegerFieldUpdater.newUpdater(QueueDynamicCompositeCancellable.class, "draining");
    private volatile int draining;
    private final Queue<Cancellable> cancellables = new ConcurrentLinkedQueue<Cancellable>();

    QueueDynamicCompositeCancellable() {
    }

    @Override
    public void cancel() {
        if (cancelledUpdater.compareAndSet(this, 0, 1)) {
            this.cancelAll();
        }
    }

    @Override
    public boolean add(Cancellable toAdd) {
        if (this.isCancelled()) {
            toAdd.cancel();
            return false;
        }
        if (!this.cancellables.offer(toAdd)) {
            throw new QueueFullException("cancellables");
        }
        if (this.isCancelled()) {
            this.cancelAll();
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Cancellable toRemove) {
        return this.cancellables.remove(toRemove);
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled != 0;
    }

    private void cancelAll() {
        ConcurrentUtils.drainSingleConsumerCollectionDelayThrow(this.cancellables, Cancellable::cancel, drainingUpdater, (Object)this);
    }
}

