/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeCompletable;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.SignalOffloader;

final class PubToCompletable<T>
extends AbstractNoHandleSubscribeCompletable {
    private final Publisher<T> source;

    PubToCompletable(Publisher<T> source) {
        super(source.executor());
        this.source = source;
    }

    @Override
    void handleSubscribe(CompletableSource.Subscriber subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        PublisherSource.Subscriber offloadedSubscription = signalOffloader.offloadSubscription(contextProvider.wrapSubscription(new PubToCompletableSubscriber(subscriber), contextMap));
        this.source.delegateSubscribe(offloadedSubscription, signalOffloader, contextMap, contextProvider);
    }

    private static final class PubToCompletableSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final CompletableSource.Subscriber subscriber;

        PubToCompletableSubscriber(CompletableSource.Subscriber subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(PublisherSource.Subscription s) {
            ConcurrentSubscription cs = ConcurrentSubscription.wrap((PublisherSource.Subscription)s);
            this.subscriber.onSubscribe((Cancellable)cs);
            cs.request(Long.MAX_VALUE);
        }

        public void onNext(T t) {
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }
    }
}

