/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.Executor;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.DelegatingExecutor;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SignalOffloaderFactory;
import io.servicetalk.concurrent.internal.SignalOffloaders;
import java.util.function.Consumer;

final class MergedOffloadSubscribeExecutor
extends DelegatingExecutor
implements SignalOffloaderFactory {
    private final io.servicetalk.concurrent.api.Executor fallbackExecutor;

    MergedOffloadSubscribeExecutor(io.servicetalk.concurrent.api.Executor subscribeOnExecutor, io.servicetalk.concurrent.api.Executor fallbackExecutor) {
        super(subscribeOnExecutor);
        this.fallbackExecutor = fallbackExecutor;
    }

    public SignalOffloader newSignalOffloader(Executor executor) {
        assert (executor == this);
        return new SubscribeOnlySignalOffloader(this.delegate, this.fallbackExecutor);
    }

    public boolean hasThreadAffinity() {
        return SignalOffloaders.hasThreadAffinity((Executor)this.delegate) && SignalOffloaders.hasThreadAffinity((Executor)this.fallbackExecutor);
    }

    private static final class SubscribeOnlySignalOffloader
    implements SignalOffloader {
        private final SignalOffloader offloader;
        private final SignalOffloader fallback;

        SubscribeOnlySignalOffloader(io.servicetalk.concurrent.api.Executor subscribeOnExecutor, io.servicetalk.concurrent.api.Executor fallbackExecutor) {
            this.offloader = SignalOffloaders.newOffloaderFor((Executor)subscribeOnExecutor);
            this.fallback = SignalOffloaders.newOffloaderFor((Executor)fallbackExecutor);
        }

        public <T> PublisherSource.Subscriber<? super T> offloadSubscriber(PublisherSource.Subscriber<? super T> subscriber) {
            return this.fallback.offloadSubscriber(subscriber);
        }

        public <T> SingleSource.Subscriber<? super T> offloadSubscriber(SingleSource.Subscriber<? super T> subscriber) {
            return this.fallback.offloadSubscriber(subscriber);
        }

        public CompletableSource.Subscriber offloadSubscriber(CompletableSource.Subscriber subscriber) {
            return this.fallback.offloadSubscriber(subscriber);
        }

        public <T> PublisherSource.Subscriber<? super T> offloadSubscription(PublisherSource.Subscriber<? super T> subscriber) {
            return this.offloader.offloadSubscription(subscriber);
        }

        public <T> SingleSource.Subscriber<? super T> offloadCancellable(SingleSource.Subscriber<? super T> subscriber) {
            return this.offloader.offloadCancellable(subscriber);
        }

        public CompletableSource.Subscriber offloadCancellable(CompletableSource.Subscriber subscriber) {
            return this.offloader.offloadCancellable(subscriber);
        }

        public <T> void offloadSubscribe(PublisherSource.Subscriber<? super T> subscriber, Consumer<PublisherSource.Subscriber<? super T>> handleSubscribe) {
            this.offloader.offloadSubscribe(subscriber, handleSubscribe);
        }

        public <T> void offloadSubscribe(SingleSource.Subscriber<? super T> subscriber, Consumer<SingleSource.Subscriber<? super T>> handleSubscribe) {
            this.offloader.offloadSubscribe(subscriber, handleSubscribe);
        }

        public void offloadSubscribe(CompletableSource.Subscriber subscriber, Consumer<CompletableSource.Subscriber> handleSubscribe) {
            this.offloader.offloadSubscribe(subscriber, handleSubscribe);
        }

        public <T> void offloadSignal(T signal, Consumer<T> signalConsumer) {
            this.offloader.offloadSignal(signal, signalConsumer);
        }
    }
}

