/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractMergeCompletableOperator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import java.util.Objects;
import javax.annotation.Nullable;

final class MergeCompletable
extends AbstractMergeCompletableOperator {
    @Nullable
    private final Completable[] others;
    @Nullable
    private final Completable onlyOther;
    private final boolean delayError;

    MergeCompletable(boolean delayError, Completable original, Executor executor, Completable ... others) {
        super(original, executor);
        this.delayError = delayError;
        switch (others.length) {
            case 0: {
                throw new IllegalArgumentException("At least one Completable required to merge");
            }
            case 1: {
                this.onlyOther = Objects.requireNonNull(others[0]);
                this.others = null;
                break;
            }
            default: {
                this.others = others;
                this.onlyOther = null;
            }
        }
    }

    @Override
    public AbstractMergeCompletableOperator.MergeSubscriber apply(CompletableSource.Subscriber subscriber) {
        assert (this.onlyOther != null || this.others != null);
        return new FixedCountMergeSubscriber(subscriber, 1 + (this.onlyOther == null ? this.others.length : 1), this.delayError);
    }

    @Override
    void doMerge(AbstractMergeCompletableOperator.MergeSubscriber subscriber) {
        if (this.onlyOther == null) {
            assert (this.others != null);
            for (Completable itr : this.others) {
                itr.subscribeInternal(subscriber);
            }
        } else {
            this.onlyOther.subscribeInternal(subscriber);
        }
    }

    static final class FixedCountMergeSubscriber
    extends AbstractMergeCompletableOperator.MergeSubscriber {
        FixedCountMergeSubscriber(CompletableSource.Subscriber subscriber, int completedCount, boolean delayError) {
            super(subscriber, completedCount, delayError);
        }

        @Override
        boolean onTerminate() {
            return completedCountUpdater.decrementAndGet(this) == 0;
        }

        @Override
        boolean isDone() {
            return this.completedCount == 0;
        }
    }
}

