/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.api.DynamicCompositeCancellable;
import io.servicetalk.concurrent.internal.ConcurrentUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class MapDynamicCompositeCancellable
implements DynamicCompositeCancellable {
    private static final AtomicIntegerFieldUpdater<MapDynamicCompositeCancellable> cancelledUpdater = AtomicIntegerFieldUpdater.newUpdater(MapDynamicCompositeCancellable.class, "cancelled");
    private volatile int cancelled;
    private static final AtomicIntegerFieldUpdater<MapDynamicCompositeCancellable> drainingUpdater = AtomicIntegerFieldUpdater.newUpdater(MapDynamicCompositeCancellable.class, "draining");
    private volatile int draining;
    private final ConcurrentMap<Cancellable, Cancellable> cancellables;

    MapDynamicCompositeCancellable() {
        this(8);
    }

    MapDynamicCompositeCancellable(int initialSize) {
        this.cancellables = new ConcurrentHashMap<Cancellable, Cancellable>(initialSize);
    }

    @Override
    public void cancel() {
        if (cancelledUpdater.compareAndSet(this, 0, 1)) {
            this.cancelAll();
        }
    }

    @Override
    public boolean add(Cancellable toAdd) {
        if (this.isCancelled()) {
            toAdd.cancel();
            return false;
        }
        this.cancellables.putIfAbsent(toAdd, toAdd);
        if (this.isCancelled()) {
            this.cancelAll();
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Cancellable toRemove) {
        return this.cancellables.remove(toRemove) != null;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled != 0;
    }

    private void cancelAll() {
        ConcurrentUtils.drainSingleConsumerCollectionDelayThrow(this.cancellables.values(), Cancellable::cancel, drainingUpdater, (Object)this);
    }
}

