/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ForEachSubscriber<T>
extends SequentialCancellable
implements PublisherSource.Subscriber<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForEachSubscriber.class);
    private final Consumer<? super T> forEach;

    ForEachSubscriber(Consumer<? super T> forEach) {
        this.forEach = Objects.requireNonNull(forEach);
    }

    public void onSubscribe(PublisherSource.Subscription s) {
        ConcurrentSubscription cs = ConcurrentSubscription.wrap((PublisherSource.Subscription)s);
        this.nextCancellable(() -> ((ConcurrentSubscription)cs).cancel());
        cs.request(Long.MAX_VALUE);
    }

    public void onNext(T t) {
        this.forEach.accept(t);
    }

    public void onError(Throwable t) {
        LOGGER.debug("Received exception from the source.", t);
    }

    public void onComplete() {
    }
}

