/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.annotation.Nullable;

final class CompositeCancellable
implements Cancellable {
    @Nullable
    private final Cancellable[] others;
    @Nullable
    private final Cancellable first;
    @Nullable
    private final Cancellable second;
    private volatile int cancelled;
    private static final AtomicIntegerFieldUpdater<CompositeCancellable> cancelledUpdater = AtomicIntegerFieldUpdater.newUpdater(CompositeCancellable.class, "cancelled");

    private CompositeCancellable(Cancellable ... others) {
        if (others.length == 2) {
            this.first = Objects.requireNonNull(others[0]);
            this.second = Objects.requireNonNull(others[1]);
            this.others = null;
        } else {
            this.others = others;
            this.first = null;
            this.second = null;
        }
    }

    public void cancel() {
        if (cancelledUpdater.compareAndSet(this, 0, 1)) {
            if (this.others == null) {
                this.first.cancel();
                this.second.cancel();
            } else {
                for (Cancellable other : this.others) {
                    other.cancel();
                }
            }
        }
    }

    static Cancellable create(Cancellable ... toCompose) {
        switch (toCompose.length) {
            case 0: {
                throw new IllegalArgumentException("At least one Cancellable required to compose.");
            }
            case 1: {
                return toCompose[0];
            }
        }
        return new CompositeCancellable(toCompose);
    }
}

