/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.internal.ConcurrentUtils;
import io.servicetalk.concurrent.internal.DelayedCancellable;
import io.servicetalk.concurrent.internal.QueueFullAndRejectedSubscribeException;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class CompletableProcessor
extends Completable
implements CompletableSource.Processor {
    private static final AtomicReferenceFieldUpdater<CompletableProcessor, TerminalNotification> terminalSignalUpdater = AtomicReferenceFieldUpdater.newUpdater(CompletableProcessor.class, TerminalNotification.class, "terminalSignal");
    private static final AtomicIntegerFieldUpdater<CompletableProcessor> drainingTheQueueUpdater = AtomicIntegerFieldUpdater.newUpdater(CompletableProcessor.class, "drainingTheQueue");
    private final Queue<CompletableSource.Subscriber> subscribers = PlatformDependent.newUnboundedLinkedMpscQueue();
    @Nullable
    private volatile TerminalNotification terminalSignal;
    private volatile int drainingTheQueue;

    CompletableProcessor() {
    }

    @Override
    protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
        DelayedCancellable delayedCancellable = new DelayedCancellable();
        subscriber.onSubscribe((Cancellable)delayedCancellable);
        if (this.subscribers.offer(subscriber)) {
            TerminalNotification terminalSignal = this.terminalSignal;
            if (terminalSignal != null) {
                this.notifyListeners(terminalSignal);
            } else {
                delayedCancellable.delayedCancellable(() -> {
                    if (!drainingTheQueueUpdater.compareAndSet(this, 0, 1)) {
                        return;
                    }
                    try {
                        this.subscribers.remove(subscriber);
                    }
                    finally {
                        drainingTheQueueUpdater.set(this, 0);
                    }
                    TerminalNotification terminalSignal2 = this.terminalSignal;
                    if (terminalSignal2 != null) {
                        this.notifyListeners(terminalSignal2);
                    }
                });
            }
        } else {
            TerminalNotification.error((Throwable)new QueueFullAndRejectedSubscribeException("subscribers")).terminate(subscriber);
        }
    }

    public void onSubscribe(Cancellable cancellable) {
    }

    public void onComplete() {
        this.terminate(TerminalNotification.complete());
    }

    public void onError(Throwable t) {
        this.terminate(TerminalNotification.error((Throwable)t));
    }

    private void terminate(TerminalNotification terminalSignal) {
        if (terminalSignalUpdater.compareAndSet(this, null, terminalSignal)) {
            this.notifyListeners(terminalSignal);
        }
    }

    private void notifyListeners(TerminalNotification terminalSignal) {
        ConcurrentUtils.drainSingleConsumerQueueDelayThrow(this.subscribers, arg_0 -> ((TerminalNotification)terminalSignal).terminate(arg_0), drainingTheQueueUpdater, (Object)this);
    }

    public void subscribe(CompletableSource.Subscriber subscriber) {
        this.subscribeInternal(subscriber);
    }
}

