/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

abstract class CancellableThenSubscription
implements PublisherSource.Subscription {
    private static final Cancellable CANCELLED = () -> {};
    private static final AtomicReferenceFieldUpdater<CancellableThenSubscription, Object> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(CancellableThenSubscription.class, Object.class, "state");
    @Nullable
    private volatile Object state;
    @Nullable
    private Cancellable firstCancellable;

    CancellableThenSubscription() {
    }

    public void request(long n) {
        block4: {
            Object s;
            block5: {
                while (true) {
                    if ((s = this.state) instanceof PublisherSource.Subscription) {
                        ((PublisherSource.Subscription)s).request(n);
                        break block4;
                    }
                    if (s == null || !SubscriberUtils.isRequestNValid((long)n)) {
                        if (!stateUpdater.compareAndSet(this, s, n)) continue;
                        break block4;
                    }
                    if (!(s instanceof Long)) break block5;
                    long longS = (Long)s;
                    if (longS < 0L || stateUpdater.compareAndSet(this, s, FlowControlUtils.addWithOverflowProtection((long)longS, (long)n))) break;
                }
                break block4;
            }
            assert (s == CANCELLED);
        }
    }

    public void cancel() {
        Object oldState = stateUpdater.getAndSet(this, CANCELLED);
        if (oldState instanceof Cancellable) {
            ((Cancellable)oldState).cancel();
        } else if (oldState != CANCELLED && this.firstCancellable != null) {
            this.firstCancellable.cancel();
            this.firstCancellable = null;
        }
    }

    final void setCancellable(Cancellable cancellable) {
        this.firstCancellable = cancellable;
    }

    final void setSubscription(PublisherSource.Subscription subscription) {
        block2: {
            this.firstCancellable = null;
            while (true) {
                Object s;
                if ((s = this.state) instanceof Long) {
                    long toRequest = (Long)s;
                    if (!stateUpdater.compareAndSet(this, s, 0L)) continue;
                    subscription.request(toRequest);
                    if (!stateUpdater.compareAndSet(this, 0L, subscription)) continue;
                    break block2;
                }
                if (s == null && stateUpdater.compareAndSet(this, null, subscription)) break block2;
                if (s == CANCELLED) break;
            }
            subscription.cancel();
        }
    }
}

