/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class BeforeFinallyPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final Runnable runnable;

    BeforeFinallyPublisher(Publisher<T> original, Runnable runnable, Executor executor) {
        super(original, executor);
        this.runnable = Objects.requireNonNull(runnable);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new BeforeFinallyPublisherSubscriber<T>(subscriber, this.runnable);
    }

    private static final class BeforeFinallyPublisherSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> original;
        private final Runnable runnable;
        private static final AtomicIntegerFieldUpdater<BeforeFinallyPublisherSubscriber> completeUpdater = AtomicIntegerFieldUpdater.newUpdater(BeforeFinallyPublisherSubscriber.class, "complete");
        private volatile int complete;

        BeforeFinallyPublisherSubscriber(PublisherSource.Subscriber<? super T> original, Runnable runnable) {
            this.original = original;
            this.runnable = runnable;
        }

        public void onSubscribe(final PublisherSource.Subscription s) {
            this.original.onSubscribe(new PublisherSource.Subscription(){

                public void request(long n) {
                    s.request(n);
                }

                public void cancel() {
                    try {
                        this.beforeFinally();
                    }
                    finally {
                        s.cancel();
                    }
                }
            });
        }

        public void onNext(T t) {
            this.original.onNext(t);
        }

        public void onComplete() {
            try {
                this.beforeFinally();
            }
            catch (Throwable err) {
                this.original.onError(err);
                return;
            }
            this.original.onComplete();
        }

        public void onError(Throwable cause) {
            try {
                this.beforeFinally();
            }
            catch (Throwable err) {
                err.addSuppressed(cause);
                this.original.onError(err);
                return;
            }
            this.original.onError(cause);
        }

        private void beforeFinally() {
            if (completeUpdater.compareAndSet(this, 0, 1)) {
                this.runnable.run();
            }
        }
    }
}

