/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletableOperator;
import io.servicetalk.concurrent.api.BeforeCancellable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class BeforeFinallyCompletable
extends AbstractSynchronousCompletableOperator {
    private final Runnable runnable;

    BeforeFinallyCompletable(Completable original, Runnable runnable, Executor executor) {
        super(original, executor);
        this.runnable = Objects.requireNonNull(runnable);
    }

    @Override
    public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
        return new BeforeFinallyCompletableSubscriber(subscriber, this.runnable);
    }

    private static final class BeforeFinallyCompletableSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber original;
        private final Runnable runnable;
        private static final AtomicIntegerFieldUpdater<BeforeFinallyCompletableSubscriber> completeUpdater = AtomicIntegerFieldUpdater.newUpdater(BeforeFinallyCompletableSubscriber.class, "complete");
        private volatile int complete;

        BeforeFinallyCompletableSubscriber(CompletableSource.Subscriber original, Runnable runnable) {
            this.original = original;
            this.runnable = runnable;
        }

        public void onSubscribe(Cancellable originalCancellable) {
            this.original.onSubscribe((Cancellable)new BeforeCancellable(this::beforeFinally, originalCancellable));
        }

        public void onComplete() {
            try {
                this.beforeFinally();
            }
            catch (Throwable error) {
                this.original.onError(error);
                return;
            }
            this.original.onComplete();
        }

        public void onError(Throwable cause) {
            try {
                this.beforeFinally();
            }
            catch (Throwable error) {
                error.addSuppressed(cause);
                this.original.onError(error);
                return;
            }
            this.original.onError(cause);
        }

        private void beforeFinally() {
            if (completeUpdater.compareAndSet(this, 0, 1)) {
                this.runnable.run();
            }
        }
    }
}

