/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class AfterFinallyPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final Runnable runnable;

    AfterFinallyPublisher(Publisher<T> original, Runnable runnable, Executor executor) {
        super(original, executor);
        this.runnable = Objects.requireNonNull(runnable);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new AfterFinallyPublisherSubscriber<T>(subscriber, this.runnable);
    }

    private static final class AfterFinallyPublisherSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> original;
        private final Runnable runnable;
        private static final AtomicIntegerFieldUpdater<AfterFinallyPublisherSubscriber> completeUpdater = AtomicIntegerFieldUpdater.newUpdater(AfterFinallyPublisherSubscriber.class, "complete");
        private volatile int complete;

        AfterFinallyPublisherSubscriber(PublisherSource.Subscriber<? super T> original, Runnable runnable) {
            this.original = original;
            this.runnable = runnable;
        }

        public void onSubscribe(final PublisherSource.Subscription s) {
            this.original.onSubscribe(new PublisherSource.Subscription(){

                public void request(long n) {
                    s.request(n);
                }

                public void cancel() {
                    try {
                        s.cancel();
                    }
                    finally {
                        this.afterFinally();
                    }
                }
            });
        }

        public void onNext(T t) {
            this.original.onNext(t);
        }

        public void onComplete() {
            try {
                this.original.onComplete();
            }
            finally {
                this.afterFinally();
            }
        }

        public void onError(Throwable cause) {
            try {
                this.original.onError(cause);
            }
            finally {
                this.afterFinally();
            }
        }

        private void afterFinally() {
            if (completeUpdater.compareAndSet(this, 0, 1)) {
                this.runnable.run();
            }
        }
    }
}

