/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletableOperator;
import io.servicetalk.concurrent.api.BeforeCancellable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class AfterFinallyCompletable
extends AbstractSynchronousCompletableOperator {
    private final Runnable runnable;

    AfterFinallyCompletable(Completable original, Runnable runnable, Executor executor) {
        super(original, executor);
        this.runnable = Objects.requireNonNull(runnable);
    }

    @Override
    public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
        return new AfterFinallyCompletableSubscriber(subscriber, this.runnable);
    }

    private static final class AfterFinallyCompletableSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber original;
        private final Runnable runnable;
        private static final AtomicIntegerFieldUpdater<AfterFinallyCompletableSubscriber> completeUpdater = AtomicIntegerFieldUpdater.newUpdater(AfterFinallyCompletableSubscriber.class, "complete");
        private volatile int complete;

        AfterFinallyCompletableSubscriber(CompletableSource.Subscriber original, Runnable runnable) {
            this.original = original;
            this.runnable = runnable;
        }

        public void onSubscribe(Cancellable originalCancellable) {
            this.original.onSubscribe((Cancellable)new BeforeCancellable(originalCancellable, this::afterFinally));
        }

        public void onComplete() {
            try {
                this.original.onComplete();
            }
            finally {
                this.afterFinally();
            }
        }

        public void onError(Throwable cause) {
            try {
                this.original.onError(cause);
            }
            finally {
                this.afterFinally();
            }
        }

        private void afterFinally() {
            if (completeUpdater.compareAndSet(this, 0, 1)) {
                this.runnable.run();
            }
        }
    }
}

