/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.CollectingSingleSubscriber;
import io.servicetalk.concurrent.api.LoggingSingleSubscriber;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TestSingleSubscriber<T>
implements SingleSource.Subscriber<T>,
Cancellable {
    private final CollectingSingleSubscriber<T> collector;
    private final SingleSource.Subscriber<T> delegate;

    public TestSingleSubscriber() {
        this.collector = new CollectingSingleSubscriber();
        this.delegate = this.collector;
    }

    private TestSingleSubscriber(CollectingSingleSubscriber<T> collector, SingleSource.Subscriber<T> delegate) {
        this.collector = collector;
        this.delegate = delegate;
    }

    public boolean cancellableReceived() {
        return this.collector.cancellableReceived();
    }

    public Cancellable cancellable() {
        return this.collector.cancellable();
    }

    public boolean hasResult() {
        return this.collector.hasResult();
    }

    @Nullable
    public T result() {
        return this.collector.result();
    }

    @Nullable
    public T takeResult() {
        return this.collector.takeResult();
    }

    @Nullable
    public Throwable error() {
        return this.collector.error();
    }

    @Nullable
    public Throwable takeError() {
        return this.collector.takeError();
    }

    public boolean isSuccess() {
        return this.collector.isSuccess();
    }

    public boolean isErrored() {
        return this.collector.isErrored();
    }

    public void cancel() {
        this.collector.cancel();
    }

    public void onSubscribe(Cancellable s) {
        this.delegate.onSubscribe(s);
    }

    public void onSuccess(T result) {
        this.delegate.onSuccess(result);
    }

    public void onError(Throwable t) {
        this.delegate.onError(t);
    }

    public static class Builder<T> {
        @Nullable
        private String loggingName;

        public Builder<T> enableLogging() {
            return this.enableLogging(TestSingleSubscriber.class.getName());
        }

        public Builder<T> enableLogging(String loggingName) {
            this.loggingName = Objects.requireNonNull(loggingName);
            return this;
        }

        public Builder<T> disableLogging() {
            this.loggingName = null;
            return this;
        }

        public TestSingleSubscriber<T> build() {
            CollectingSingleSubscriber collector;
            Object delegate = collector = new CollectingSingleSubscriber();
            if (this.loggingName != null) {
                delegate = new LoggingSingleSubscriber(this.loggingName, delegate);
            }
            return new TestSingleSubscriber(collector, (SingleSource.Subscriber)delegate);
        }
    }
}

