/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.DynamicCompositeCancellable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.MapDynamicCompositeCancellable;
import io.servicetalk.concurrent.api.Single;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

@Deprecated
public class LegacyTestSingle<T>
extends Single<T>
implements SingleSource.Subscriber<T> {
    private static final Object NULL = new Object();
    private final AtomicInteger subscribeCount = new AtomicInteger();
    private final Queue<SingleSource.Subscriber<? super T>> subscribers = new ConcurrentLinkedQueue<SingleSource.Subscriber<? super T>>();
    private final DynamicCompositeCancellable dynamicCancellable = new MapDynamicCompositeCancellable();
    private final boolean invokeListenerPostCancel;
    private final boolean cacheResults;
    @Nullable
    private Object cachedResult;

    public LegacyTestSingle() {
        this(false);
    }

    public LegacyTestSingle(boolean invokeListenerPostCancel) {
        this(invokeListenerPostCancel, true);
    }

    public LegacyTestSingle(boolean invokeListenerPostCancel, boolean cacheResults) {
        this.invokeListenerPostCancel = invokeListenerPostCancel;
        this.cacheResults = cacheResults;
    }

    public LegacyTestSingle(Executor executor, boolean invokeListenerPostCancel, boolean cacheResults) {
        super(executor);
        this.invokeListenerPostCancel = invokeListenerPostCancel;
        this.cacheResults = cacheResults;
    }

    public synchronized void handleSubscribe(SingleSource.Subscriber<? super T> subscriber) {
        this.subscribeCount.incrementAndGet();
        this.subscribers.add(subscriber);
        subscriber.onSubscribe(() -> {
            if (!this.invokeListenerPostCancel) {
                this.subscribers.remove(subscriber);
            }
            this.dynamicCancellable.cancel();
        });
        if (this.cachedResult != null) {
            this.subscribers.remove(subscriber);
            if (this.cachedResult instanceof Throwable) {
                subscriber.onError((Throwable)this.cachedResult);
            } else if (this.cachedResult == NULL) {
                subscriber.onSuccess(null);
            } else {
                Object t = this.cachedResult;
                subscriber.onSuccess(t);
            }
        }
    }

    public void onSubscribe(Cancellable cancellable) {
        this.dynamicCancellable.add(cancellable);
    }

    public synchronized void onSuccess(@Nullable T result) {
        ArrayList<SingleSource.Subscriber<T>> subs = new ArrayList<SingleSource.Subscriber<T>>(this.subscribers);
        this.subscribers.clear();
        for (SingleSource.Subscriber subscriber : subs) {
            subscriber.onSuccess(result);
        }
        if (this.cacheResults) {
            this.cachedResult = result == null ? NULL : result;
        }
    }

    public synchronized void onError(Throwable t) {
        ArrayList<SingleSource.Subscriber<T>> subs = new ArrayList<SingleSource.Subscriber<T>>(this.subscribers);
        this.subscribers.clear();
        for (SingleSource.Subscriber subscriber : subs) {
            subscriber.onError(t);
        }
        if (this.cacheResults) {
            this.cachedResult = t;
        }
    }

    public boolean isCancelled() {
        return this.dynamicCancellable.isCancelled();
    }

    public LegacyTestSingle<T> verifyListenCalled() {
        MatcherAssert.assertThat((String)"Listen not called.", this.subscribers, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        return this;
    }

    public LegacyTestSingle<T> verifyListenCalled(int times) {
        int count = this.subscribeCount.get();
        MatcherAssert.assertThat((String)("Listen not called " + times + " but instead " + count), (Object)count, (Matcher)Matchers.equalTo((Object)times));
        return this;
    }

    public LegacyTestSingle<T> verifyListenNotCalled() {
        MatcherAssert.assertThat((String)"Listen called.", this.subscribers, (Matcher)Matchers.hasSize((int)0));
        return this;
    }

    public LegacyTestSingle<T> verifyCancelled() {
        Assert.assertTrue((String)"Subscriber did not cancel.", (boolean)this.isCancelled());
        return this;
    }

    public LegacyTestSingle<T> verifyNotCancelled() {
        Assert.assertFalse((String)"Subscriber cancelled.", (boolean)this.isCancelled());
        return this;
    }
}

