/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;

public final class ConcurrentPublisherSubscriberFunction<T>
implements Function<PublisherSource.Subscriber<? super T>, PublisherSource.Subscriber<? super T>> {
    private final List<PublisherSource.Subscriber<? super T>> subscribers = new CopyOnWriteArrayList<PublisherSource.Subscriber<? super T>>();
    private final PublisherSource.Subscriber<T> listSubscriber = new PublisherSource.Subscriber<T>(){

        public void onSubscribe(PublisherSource.Subscription s) {
            for (PublisherSource.Subscriber subscriber : ConcurrentPublisherSubscriberFunction.this.subscribers) {
                subscriber.onSubscribe(s);
            }
        }

        public void onNext(T t) {
            for (PublisherSource.Subscriber subscriber : ConcurrentPublisherSubscriberFunction.this.subscribers) {
                subscriber.onNext(t);
            }
        }

        public void onError(Throwable t) {
            for (PublisherSource.Subscriber subscriber : ConcurrentPublisherSubscriberFunction.this.subscribers) {
                subscriber.onError(t);
            }
        }

        public void onComplete() {
            for (PublisherSource.Subscriber subscriber : ConcurrentPublisherSubscriberFunction.this.subscribers) {
                subscriber.onComplete();
            }
        }
    };

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        this.subscribers.add(subscriber);
        return this.listSubscriber;
    }

    public List<PublisherSource.Subscriber<? super T>> subscribers() {
        return new ArrayList<PublisherSource.Subscriber<? super T>>(this.subscribers);
    }
}

