/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.ThrowableUtils;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public final class BlockingTestUtils {
    private static final NullPointerException AWAIT_PUBLISHER_NPE = (NullPointerException)ThrowableUtils.unknownStackTrace((Throwable)new NullPointerException(), BlockingTestUtils.class, (String)("awaitIndefinitelyNonNull(" + Publisher.class.getSimpleName() + ")"));
    private static final NullPointerException AWAIT_PUBLISHER_TIMEOUT_NPE = (NullPointerException)ThrowableUtils.unknownStackTrace((Throwable)new NullPointerException(), BlockingTestUtils.class, (String)("awaitNonNull(" + Publisher.class.getSimpleName() + ", ..)"));
    private static final NullPointerException AWAIT_SINGLE_NPE = (NullPointerException)ThrowableUtils.unknownStackTrace((Throwable)new NullPointerException(), BlockingTestUtils.class, (String)("awaitIndefinitelyNonNull(" + Single.class.getSimpleName() + ")"));
    private static final NullPointerException AWAIT_SINGLE_TIMEOUT_NPE = (NullPointerException)ThrowableUtils.unknownStackTrace((Throwable)new NullPointerException(), BlockingTestUtils.class, (String)("awaitNonNull(" + Single.class.getSimpleName() + ", ..)"));

    private BlockingTestUtils() {
    }

    @Nullable
    public static <T> List<T> awaitIndefinitely(Publisher<T> source) throws ExecutionException, InterruptedException {
        return BlockingTestUtils.toList((Collection)source.toFuture().get());
    }

    public static <T> List<T> awaitIndefinitelyNonNull(Publisher<T> source) throws ExecutionException, InterruptedException {
        return BlockingTestUtils.enforceNonNull(BlockingTestUtils.awaitIndefinitely(source), AWAIT_PUBLISHER_NPE);
    }

    @Nullable
    public static <T> List<T> await(Publisher<T> source, long timeout, TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
        return BlockingTestUtils.toList((Collection)source.toFuture().get(timeout, timeoutUnit));
    }

    public static <T> List<T> awaitNonNull(Publisher<T> source, long timeout, TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
        return BlockingTestUtils.enforceNonNull(BlockingTestUtils.await(source, timeout, timeoutUnit), AWAIT_PUBLISHER_TIMEOUT_NPE);
    }

    @Nullable
    public static <T> T awaitIndefinitely(Single<T> source) throws ExecutionException, InterruptedException {
        return (T)source.toFuture().get();
    }

    public static <T> T awaitIndefinitelyNonNull(Single<T> source) throws ExecutionException, InterruptedException {
        return BlockingTestUtils.enforceNonNull(BlockingTestUtils.awaitIndefinitely(source), AWAIT_SINGLE_NPE);
    }

    @Nullable
    public static <T> T await(Single<T> source, long timeout, TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
        return (T)source.toFuture().get(timeout, timeoutUnit);
    }

    public static <T> T awaitNonNull(Single<T> source, long timeout, TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
        return BlockingTestUtils.enforceNonNull(BlockingTestUtils.await(source, timeout, timeoutUnit), AWAIT_SINGLE_TIMEOUT_NPE);
    }

    public static void awaitIndefinitely(Completable source) throws ExecutionException, InterruptedException {
        source.toFuture().get();
    }

    public static void awaitIndefinitelyUnchecked(Completable source) {
        try {
            BlockingTestUtils.awaitIndefinitely(source);
        }
        catch (InterruptedException | ExecutionException e) {
            PlatformDependent.throwException((Throwable)e);
        }
    }

    public static void await(Completable source, long timeout, TimeUnit timeoutUnit) throws ExecutionException, InterruptedException, TimeoutException {
        source.toFuture().get(timeout, timeoutUnit);
    }

    private static <T> T enforceNonNull(@Nullable T result, NullPointerException npe) throws ExecutionException {
        if (result == null) {
            throw new ExecutionException("null return value not supported", npe);
        }
        return result;
    }

    @Nullable
    private static <T> List<T> toList(@Nullable Collection<T> collection) {
        return collection instanceof List ? (List)collection : (collection == null ? null : new ArrayList<T>(collection));
    }
}

