/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.circuit.breaker.resilience4j;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.event.CircuitBreakerEvent;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class Resilience4jAdapters {
    private static final int IGNORE_RETRIES_ARG = 1;

    private Resilience4jAdapters() {
    }

    public static io.servicetalk.circuit.breaker.api.CircuitBreaker fromCircuitBreaker(CircuitBreaker breaker) {
        return new R4jCircuitBreaker(Objects.requireNonNull(breaker));
    }

    private static final class R4jCircuitBreaker
    implements io.servicetalk.circuit.breaker.api.CircuitBreaker {
        private final CircuitBreaker breaker;
        private long breakerOpenedAtMillis;

        private R4jCircuitBreaker(CircuitBreaker breaker) {
            this.breaker = breaker;
            this.breaker.getEventPublisher().onStateTransition(event -> {
                if (event.getEventType() == CircuitBreakerEvent.Type.STATE_TRANSITION && event.getStateTransition().getToState() == CircuitBreaker.State.OPEN) {
                    this.breakerOpenedAtMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                }
            });
        }

        public String name() {
            return this.breaker.getName();
        }

        public boolean tryAcquirePermit() {
            return this.breaker.tryAcquirePermission();
        }

        public void ignorePermit() {
            this.breaker.releasePermission();
        }

        public void onError(long duration, TimeUnit durationUnit, Throwable throwable) {
            this.breaker.onError(duration, durationUnit, throwable);
        }

        public void onSuccess(long duration, TimeUnit durationUnit) {
            this.breaker.onSuccess(duration, durationUnit);
        }

        public void forceOpenState() {
            this.breaker.transitionToForcedOpenState();
        }

        public void reset() {
            this.breaker.reset();
        }

        public Duration remainingDurationInOpenState() {
            long openDurationMillis = (Long)this.breaker.getCircuitBreakerConfig().getWaitIntervalFunctionInOpenState().apply((Object)1);
            long openDeadline = this.breakerOpenedAtMillis + openDurationMillis;
            return Duration.ofMillis(Math.max(0L, openDeadline - TimeUnit.NANOSECONDS.toMillis(System.nanoTime())));
        }
    }
}

