/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.ByteProcessor;
import io.servicetalk.buffer.netty.BufferUtils;
import io.servicetalk.buffer.netty.ReadOnlyBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

class NettyBuffer<T extends ByteBuf>
implements Buffer {
    final T buffer;

    NettyBuffer(T buffer) {
        this.buffer = buffer;
    }

    public int capacity() {
        return this.buffer.capacity();
    }

    public Buffer capacity(int newCapacity) {
        this.buffer.capacity(newCapacity);
        return this;
    }

    public int maxCapacity() {
        return this.buffer.maxCapacity();
    }

    public int readerIndex() {
        return this.buffer.readerIndex();
    }

    public Buffer readerIndex(int readerIndex) {
        this.buffer.readerIndex(readerIndex);
        return this;
    }

    public int writerIndex() {
        return this.buffer.writerIndex();
    }

    public Buffer writerIndex(int writerIndex) {
        this.buffer.writerIndex(writerIndex);
        return this;
    }

    public int readableBytes() {
        return this.buffer.readableBytes();
    }

    public int writableBytes() {
        return this.buffer.writableBytes();
    }

    public int maxWritableBytes() {
        return this.buffer.maxWritableBytes();
    }

    public Buffer ensureWritable(int minWritableBytes) {
        this.buffer.ensureWritable(minWritableBytes);
        return this;
    }

    public int ensureWritable(int minWritableBytes, boolean force) {
        return this.buffer.ensureWritable(minWritableBytes, force);
    }

    public Buffer clear() {
        this.buffer.clear();
        return this;
    }

    public boolean getBoolean(int index) {
        return this.buffer.getBoolean(index);
    }

    public byte getByte(int index) {
        return this.buffer.getByte(index);
    }

    public short getUnsignedByte(int index) {
        return this.buffer.getUnsignedByte(index);
    }

    public short getShort(int index) {
        return this.buffer.getShort(index);
    }

    public short getShortLE(int index) {
        return this.buffer.getShortLE(index);
    }

    public int getUnsignedShort(int index) {
        return this.buffer.getUnsignedShort(index);
    }

    public int getUnsignedShortLE(int index) {
        return this.buffer.getUnsignedShortLE(index);
    }

    public int getMedium(int index) {
        return this.buffer.getMedium(index);
    }

    public int getMediumLE(int index) {
        return this.buffer.getMediumLE(index);
    }

    public int getUnsignedMedium(int index) {
        return this.buffer.getUnsignedMedium(index);
    }

    public int getUnsignedMediumLE(int index) {
        return this.buffer.getUnsignedMediumLE(index);
    }

    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    public int getIntLE(int index) {
        return this.buffer.getIntLE(index);
    }

    public long getUnsignedInt(int index) {
        return this.buffer.getUnsignedInt(index);
    }

    public long getUnsignedIntLE(int index) {
        return this.buffer.getUnsignedIntLE(index);
    }

    public long getLong(int index) {
        return this.buffer.getLong(index);
    }

    public long getLongLE(int index) {
        return this.buffer.getLongLE(index);
    }

    public char getChar(int index) {
        return this.buffer.getChar(index);
    }

    public float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    public double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    public Buffer getBytes(int index, Buffer dst) {
        return this.getBytes(index, dst, dst.writableBytes());
    }

    public Buffer getBytes(int index, Buffer dst, int length) {
        this.getBytes(index, dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
        return this;
    }

    public Buffer getBytes(int index, Buffer dst, int dstIndex, int length) {
        ByteBuf dstByteBuf = BufferUtils.toByteBufNoThrow(dst);
        if (dstByteBuf != null) {
            this.buffer.getBytes(index, dstByteBuf, dstIndex, length);
        } else if (dst.hasArray()) {
            this.buffer.getBytes(index, dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            ByteBuffer nioBuffer = dst.toNioBuffer(dstIndex, length);
            this.buffer.getBytes(index, nioBuffer);
        }
        return this;
    }

    public Buffer getBytes(int index, byte[] dst) {
        return this.getBytes(index, dst, 0, dst.length);
    }

    public Buffer getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buffer.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public Buffer getBytes(int index, ByteBuffer dst) {
        this.buffer.getBytes(index, dst);
        return this;
    }

    public Buffer setBoolean(int index, boolean value) {
        this.buffer.setBoolean(index, value);
        return this;
    }

    public Buffer setByte(int index, int value) {
        this.buffer.setByte(index, value);
        return this;
    }

    public Buffer setShort(int index, int value) {
        this.buffer.setShort(index, value);
        return this;
    }

    public Buffer setShortLE(int index, int value) {
        this.buffer.setShortLE(index, value);
        return this;
    }

    public Buffer setMedium(int index, int value) {
        this.buffer.setMedium(index, value);
        return this;
    }

    public Buffer setMediumLE(int index, int value) {
        this.buffer.setMediumLE(index, value);
        return this;
    }

    public Buffer setInt(int index, int value) {
        this.buffer.setInt(index, value);
        return this;
    }

    public Buffer setIntLE(int index, int value) {
        this.buffer.setIntLE(index, value);
        return this;
    }

    public Buffer setLong(int index, long value) {
        this.buffer.setLong(index, value);
        return this;
    }

    public Buffer setLongLE(int index, long value) {
        this.buffer.setLongLE(index, value);
        return this;
    }

    public Buffer setChar(int index, int value) {
        this.buffer.setChar(index, value);
        return this;
    }

    public Buffer setFloat(int index, float value) {
        this.buffer.setFloat(index, value);
        return this;
    }

    public Buffer setDouble(int index, double value) {
        this.buffer.setDouble(index, value);
        return this;
    }

    public Buffer setBytes(int index, Buffer src) {
        return this.setBytes(index, src, src.readableBytes());
    }

    public Buffer setBytes(int index, Buffer src, int length) {
        this.setBytes(index, src, src.readerIndex(), length);
        src.readerIndex(src.readerIndex() + length);
        return this;
    }

    public Buffer setBytes(int index, Buffer src, int srcIndex, int length) {
        ByteBuf srcByteBuf = BufferUtils.toByteBufNoThrow(src);
        if (srcByteBuf != null) {
            this.buffer.setBytes(index, srcByteBuf, srcIndex, length);
        } else if (src.hasArray()) {
            this.buffer.setBytes(index, src.array(), src.arrayOffset() + srcIndex, length);
        } else {
            ByteBuffer nioBuffer = src.toNioBuffer(srcIndex, length);
            this.buffer.setBytes(index, nioBuffer);
        }
        return this;
    }

    public Buffer setBytes(int index, byte[] src) {
        return this.setBytes(index, src, 0, src.length);
    }

    public Buffer setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buffer.setBytes(index, src, srcIndex, length);
        return this;
    }

    public Buffer setBytes(int index, ByteBuffer src) {
        this.buffer.setBytes(index, src);
        return this;
    }

    public int setBytes(int index, InputStream src, int length) throws IOException {
        int bytesWritten;
        int totalWritten = 0;
        while (length > 0 && (bytesWritten = this.buffer.setBytes(index, src, length)) >= 0) {
            totalWritten += bytesWritten;
            length -= bytesWritten;
            index += bytesWritten;
        }
        return totalWritten;
    }

    public int setBytesUntilEndStream(int index, InputStream src, int chunkSize) throws IOException {
        int i = index;
        int writableBytes = chunkSize;
        while (true) {
            this.buffer.ensureWritable(writableBytes);
            int result = this.buffer.setBytes(i, src, chunkSize);
            if (result == -1) break;
            i += result;
            writableBytes += chunkSize;
        }
        return i - index;
    }

    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    public byte readByte() {
        return this.buffer.readByte();
    }

    public short readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    public short readShort() {
        return this.buffer.readShort();
    }

    public short readShortLE() {
        return this.buffer.readShortLE();
    }

    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.buffer.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.buffer.readMedium();
    }

    public int readMediumLE() {
        return this.buffer.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.buffer.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.buffer.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.buffer.readInt();
    }

    public int readIntLE() {
        return this.buffer.readIntLE();
    }

    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.buffer.readUnsignedIntLE();
    }

    public long readLong() {
        return this.buffer.readLong();
    }

    public long readLongLE() {
        return this.buffer.readLongLE();
    }

    public char readChar() {
        return this.buffer.readChar();
    }

    public float readFloat() {
        return this.buffer.readFloat();
    }

    public double readDouble() {
        return this.buffer.readDouble();
    }

    public Buffer readSlice(int length) {
        return new NettyBuffer<ByteBuf>(this.buffer.readSlice(length));
    }

    public Buffer readBytes(int length) {
        return new NettyBuffer<ByteBuf>(this.buffer.readBytes(length));
    }

    public Buffer readBytes(Buffer dst) {
        return this.readBytes(dst, dst.writableBytes());
    }

    public Buffer readBytes(Buffer dst, int length) {
        this.readBytes(dst, dst.writerIndex(), length);
        dst.writerIndex(dst.writerIndex() + length);
        return this;
    }

    public Buffer readBytes(Buffer dst, int dstIndex, int length) {
        ByteBuf dstByteBuf = BufferUtils.toByteBufNoThrow(dst);
        if (dstByteBuf != null) {
            this.buffer.readBytes(dstByteBuf, dstIndex, length);
        } else if (dst.hasArray()) {
            this.buffer.readBytes(dst.array(), dst.arrayOffset() + dstIndex, length);
        } else {
            ByteBuffer nioBuffer = dst.toNioBuffer(dstIndex, length);
            this.buffer.readBytes(nioBuffer);
        }
        return this;
    }

    public Buffer readBytes(byte[] dst) {
        return this.readBytes(dst, 0, dst.length);
    }

    public Buffer readBytes(byte[] dst, int dstIndex, int length) {
        this.buffer.readBytes(dst, dstIndex, length);
        return this;
    }

    public Buffer readBytes(ByteBuffer dst) {
        this.buffer.readBytes(dst);
        return this;
    }

    public Buffer skipBytes(int length) {
        this.buffer.skipBytes(length);
        return this;
    }

    public Buffer writeBoolean(boolean value) {
        this.buffer.writeBoolean(value);
        return this;
    }

    public Buffer writeByte(int value) {
        this.buffer.writeByte(value);
        return this;
    }

    public Buffer writeShort(int value) {
        this.buffer.writeShort(value);
        return this;
    }

    public Buffer writeShortLE(int value) {
        this.buffer.writeShortLE(value);
        return this;
    }

    public Buffer writeMedium(int value) {
        this.buffer.writeMedium(value);
        return this;
    }

    public Buffer writeMediumLE(int value) {
        this.buffer.writeMediumLE(value);
        return this;
    }

    public Buffer writeInt(int value) {
        this.buffer.writeInt(value);
        return this;
    }

    public Buffer writeIntLE(int value) {
        this.buffer.writeIntLE(value);
        return this;
    }

    public Buffer writeLong(long value) {
        this.buffer.writeLong(value);
        return this;
    }

    public Buffer writeLongLE(long value) {
        this.buffer.writeLongLE(value);
        return this;
    }

    public Buffer writeChar(int value) {
        this.buffer.writeChar(value);
        return this;
    }

    public Buffer writeFloat(float value) {
        this.buffer.writeFloat(value);
        return this;
    }

    public Buffer writeDouble(double value) {
        this.buffer.writeDouble(value);
        return this;
    }

    public Buffer writeBytes(Buffer src) {
        return this.writeBytes(src, src.readableBytes());
    }

    public Buffer writeBytes(Buffer src, int length) {
        this.writeBytes(src, src.readerIndex(), length);
        src.readerIndex(src.readerIndex() + length);
        return this;
    }

    public Buffer writeBytes(Buffer src, int srcIndex, int length) {
        ByteBuf srcByteBuf = BufferUtils.toByteBufNoThrow(src);
        if (srcByteBuf != null) {
            this.buffer.writeBytes(srcByteBuf, srcIndex, length);
        } else if (src.hasArray()) {
            this.buffer.writeBytes(src.array(), src.arrayOffset() + srcIndex, length);
        } else {
            ByteBuffer nioBuffer = src.toNioBuffer(srcIndex, length);
            this.buffer.writeBytes(nioBuffer);
        }
        return this;
    }

    public Buffer writeBytes(byte[] src) {
        return this.writeBytes(src, 0, src.length);
    }

    public Buffer writeBytes(byte[] src, int srcIndex, int length) {
        this.buffer.writeBytes(src, srcIndex, length);
        return this;
    }

    public Buffer writeBytes(ByteBuffer src) {
        this.buffer.writeBytes(src);
        return this;
    }

    public int writeBytes(InputStream src, int length) throws IOException {
        int bytesWritten;
        int totalWritten = 0;
        while (length > 0 && (bytesWritten = this.buffer.writeBytes(src, length)) >= 0) {
            totalWritten += bytesWritten;
            length -= bytesWritten;
        }
        return totalWritten;
    }

    public int writeBytesUntilEndStream(InputStream src, int chunkSize) throws IOException {
        int amountRead = this.setBytesUntilEndStream(this.buffer.writerIndex(), src, chunkSize);
        if (amountRead > 0) {
            this.buffer.writerIndex(this.buffer.writerIndex() + amountRead);
        }
        return amountRead;
    }

    public Buffer writeAscii(CharSequence seq) {
        ByteBufUtil.writeAscii(this.buffer, (CharSequence)seq);
        return this;
    }

    public Buffer writeUtf8(CharSequence seq) {
        ByteBufUtil.writeUtf8(this.buffer, (CharSequence)seq);
        return this;
    }

    public Buffer writeUtf8(CharSequence seq, int ensureWritable) {
        ByteBufUtil.reserveAndWriteUtf8(this.buffer, (CharSequence)seq, (int)ensureWritable);
        return this;
    }

    public Buffer writeCharSequence(CharSequence seq, Charset charset) {
        this.buffer.writeCharSequence(seq, charset);
        return this;
    }

    public int indexOf(int fromIndex, int toIndex, byte value) {
        return this.buffer.indexOf(fromIndex, toIndex, value);
    }

    public int bytesBefore(byte value) {
        return this.buffer.bytesBefore(value);
    }

    public int bytesBefore(int length, byte value) {
        return this.buffer.bytesBefore(length, value);
    }

    public int bytesBefore(int index, int length, byte value) {
        return this.buffer.bytesBefore(index, length, value);
    }

    public Buffer copy() {
        return new NettyBuffer<ByteBuf>(this.buffer.copy());
    }

    public Buffer copy(int index, int length) {
        return new NettyBuffer<ByteBuf>(this.buffer.copy(index, length));
    }

    public Buffer slice() {
        return new NettyBuffer<ByteBuf>(this.buffer.slice());
    }

    public Buffer slice(int index, int length) {
        return new NettyBuffer<ByteBuf>(this.buffer.slice(index, length));
    }

    public Buffer duplicate() {
        return new NettyBuffer<ByteBuf>(this.buffer.duplicate());
    }

    public int nioBufferCount() {
        return this.buffer.nioBufferCount();
    }

    public ByteBuffer toNioBuffer() {
        return this.buffer.nioBuffer();
    }

    public ByteBuffer toNioBuffer(int index, int length) {
        return this.buffer.nioBuffer(index, length);
    }

    public ByteBuffer[] toNioBuffers() {
        return this.buffer.nioBuffers();
    }

    public ByteBuffer[] toNioBuffers(int index, int length) {
        return this.buffer.nioBuffers(index, length);
    }

    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    public Buffer asReadOnly() {
        return new ReadOnlyBuffer(this);
    }

    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    public boolean hasArray() {
        return this.buffer.hasArray();
    }

    public byte[] array() {
        return this.buffer.array();
    }

    public int arrayOffset() {
        return this.buffer.arrayOffset();
    }

    public int forEachByte(ByteProcessor processor) {
        return this.buffer.forEachByte(arg_0 -> ((ByteProcessor)processor).process(arg_0));
    }

    public int forEachByte(int index, int length, ByteProcessor processor) {
        return this.buffer.forEachByte(index, length, arg_0 -> ((ByteProcessor)processor).process(arg_0));
    }

    public int forEachByteDesc(ByteProcessor processor) {
        return this.buffer.forEachByteDesc(arg_0 -> ((ByteProcessor)processor).process(arg_0));
    }

    public int forEachByteDesc(int index, int length, ByteProcessor processor) {
        return this.buffer.forEachByteDesc(index, length, arg_0 -> ((ByteProcessor)processor).process(arg_0));
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Buffer) {
            Buffer other = (Buffer)obj;
            ByteBuf byteBuf = BufferUtils.toByteBufNoThrow(other);
            return byteBuf != null ? this.buffer.equals((Object)byteBuf) : this.buffer.nioBuffer().equals(other.toNioBuffer());
        }
        return false;
    }

    public String toString() {
        return "NettyBuffer{buffer=" + this.buffer + '}';
    }

    public String toString(Charset charset) {
        return this.buffer.toString(charset);
    }

    public String toString(int index, int length, Charset charset) {
        return this.buffer.toString(index, length, charset);
    }
}

