/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.netty;

import io.netty.buffer.ByteBufAllocator;
import io.servicetalk.buffer.netty.UnreleasableUnsafeDirectByteBuf;
import io.servicetalk.utils.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class UnreleasableUnsafeNoZeroingDirectByteBuf
extends UnreleasableUnsafeDirectByteBuf {
    UnreleasableUnsafeNoZeroingDirectByteBuf(ByteBufAllocator alloc, int initialCapacity, int maxCapacity) {
        super(alloc, initialCapacity, maxCapacity);
    }

    protected ByteBuffer allocateDirect(int initialCapacity) {
        long memoryAddress;
        long size = Math.max(1, initialCapacity);
        PlatformDependent.reserveMemory((long)size, (int)initialCapacity);
        try {
            memoryAddress = PlatformDependent.allocateMemory((long)size);
        }
        catch (Throwable e) {
            PlatformDependent.unreserveMemory((long)size, (int)initialCapacity);
            return (ByteBuffer)PlatformDependent.throwException((Throwable)e);
        }
        try {
            return PlatformDependent.newDirectBuffer((long)memoryAddress, (long)size, (int)initialCapacity);
        }
        catch (Throwable e) {
            PlatformDependent.freeMemory((long)memoryAddress);
            PlatformDependent.unreserveMemory((long)size, (int)initialCapacity);
            return (ByteBuffer)PlatformDependent.throwException((Throwable)e);
        }
    }
}

