/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.buffer.netty;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.buffer.api.CompositeBuffer;
import io.servicetalk.buffer.api.EmptyBuffer;
import io.servicetalk.buffer.netty.NettyBuffer;
import io.servicetalk.buffer.netty.NettyCompositeBuffer;
import io.servicetalk.buffer.netty.UnreleasableCompositeByteBuf;
import io.servicetalk.buffer.netty.UnreleasableDirectByteBuf;
import io.servicetalk.buffer.netty.UnreleasableHeapByteBuf;
import io.servicetalk.buffer.netty.UnreleasableNoZeroingHeapByteBuf;
import io.servicetalk.buffer.netty.UnreleasableUnsafeDirectByteBuf;
import io.servicetalk.buffer.netty.UnreleasableUnsafeNoZeroingDirectByteBuf;
import io.servicetalk.utils.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

final class ServiceTalkBufferAllocator
extends AbstractByteBufAllocator
implements BufferAllocator {
    private final ByteBufAllocator forceHeapAllocator = new ForceTypeByteBufAllocator((ByteBufAllocator)this, false);
    private final ByteBufAllocator forceDirectAllocator = new ForceTypeByteBufAllocator((ByteBufAllocator)this, true);
    private final boolean noZeroing = PlatformDependent.useDirectBufferWithoutZeroing();

    ServiceTalkBufferAllocator(boolean preferDirect) {
        super(preferDirect);
    }

    protected ByteBuf newHeapBuffer(int initialCapacity, int maxCapacity) {
        return io.netty.util.internal.PlatformDependent.hasUnsafe() ? new UnreleasableNoZeroingHeapByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity) : new UnreleasableHeapByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
    }

    protected ByteBuf newDirectBuffer(int initialCapacity, int maxCapacity) {
        if (this.noZeroing) {
            return new UnreleasableUnsafeNoZeroingDirectByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
        }
        return io.netty.util.internal.PlatformDependent.hasUnsafe() ? new UnreleasableUnsafeDirectByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity) : new UnreleasableDirectByteBuf((ByteBufAllocator)this, initialCapacity, maxCapacity);
    }

    public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
        return new UnreleasableCompositeByteBuf((ByteBufAllocator)this, false, maxNumComponents);
    }

    public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
        return new UnreleasableCompositeByteBuf((ByteBufAllocator)this, true, maxNumComponents);
    }

    public boolean isDirectBufferPooled() {
        return false;
    }

    public Buffer fromUtf8(CharSequence data) {
        return data.length() == 0 ? EmptyBuffer.EMPTY_BUFFER : new NettyBuffer<ByteBuf>(ByteBufUtil.writeUtf8((ByteBufAllocator)this, (CharSequence)data));
    }

    public Buffer fromUtf8(CharSequence data, boolean direct) {
        return data.length() == 0 ? EmptyBuffer.EMPTY_BUFFER : new NettyBuffer<ByteBuf>(ByteBufUtil.writeUtf8((ByteBufAllocator)(direct ? this.forceDirectAllocator : this.forceHeapAllocator), (CharSequence)data));
    }

    public Buffer fromAscii(CharSequence data) {
        return data.length() == 0 ? EmptyBuffer.EMPTY_BUFFER : new NettyBuffer<ByteBuf>(ByteBufUtil.writeAscii((ByteBufAllocator)this, (CharSequence)data));
    }

    public Buffer fromAscii(CharSequence data, boolean direct) {
        return data.length() == 0 ? EmptyBuffer.EMPTY_BUFFER : new NettyBuffer<ByteBuf>(ByteBufUtil.writeAscii((ByteBufAllocator)(direct ? this.forceDirectAllocator : this.forceHeapAllocator), (CharSequence)data));
    }

    public Buffer fromSequence(CharSequence data, Charset charset) {
        if (charset == StandardCharsets.US_ASCII) {
            return this.fromAscii(data);
        }
        if (charset == StandardCharsets.UTF_8) {
            return this.fromUtf8(data);
        }
        return data.length() == 0 ? EmptyBuffer.EMPTY_BUFFER : new NettyBuffer<ByteBuf>(ByteBufUtil.encodeString((ByteBufAllocator)this, (CharBuffer)(data instanceof CharBuffer ? (CharBuffer)data : CharBuffer.wrap(data)), (Charset)charset));
    }

    public Buffer fromSequence(CharSequence data, Charset charset, boolean direct) {
        if (charset == StandardCharsets.US_ASCII) {
            return this.fromAscii(data, direct);
        }
        if (charset == StandardCharsets.UTF_8) {
            return this.fromUtf8(data, direct);
        }
        return data.length() == 0 ? EmptyBuffer.EMPTY_BUFFER : new NettyBuffer<ByteBuf>(ByteBufUtil.encodeString((ByteBufAllocator)(direct ? this.forceDirectAllocator : this.forceHeapAllocator), (CharBuffer)(data instanceof CharBuffer ? (CharBuffer)data : CharBuffer.wrap(data)), (Charset)charset));
    }

    public Buffer newBuffer(int initialCapacity) {
        return new NettyBuffer<ByteBuf>(this.buffer(initialCapacity));
    }

    public Buffer newBuffer(int initialCapacity, boolean direct) {
        return new NettyBuffer<ByteBuf>(direct ? this.directBuffer(initialCapacity) : this.heapBuffer(initialCapacity));
    }

    public CompositeBuffer newCompositeBuffer() {
        return new NettyCompositeBuffer(this.compositeBuffer());
    }

    public CompositeBuffer newCompositeBuffer(int maxComponents) {
        return new NettyCompositeBuffer(this.compositeBuffer(maxComponents));
    }

    public Buffer wrap(byte[] bytes) {
        return bytes.length == 0 ? EmptyBuffer.EMPTY_BUFFER : new NettyBuffer<UnreleasableHeapByteBuf>(new UnreleasableHeapByteBuf((ByteBufAllocator)this, bytes, bytes.length));
    }

    public Buffer wrap(ByteBuffer buffer) {
        NettyBuffer<Object> buf = buffer.hasArray() ? this.wrap(buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining()) : (buffer.isDirect() && io.netty.util.internal.PlatformDependent.hasUnsafe() ? new NettyBuffer<UnreleasableUnsafeDirectByteBuf>(new UnreleasableUnsafeDirectByteBuf((ByteBufAllocator)this, buffer, buffer.remaining())) : new NettyBuffer<UnreleasableDirectByteBuf>(new UnreleasableDirectByteBuf((ByteBufAllocator)this, buffer, buffer.remaining())));
        return buffer.isReadOnly() ? buf.asReadOnly() : buf;
    }

    private static final class ForceTypeByteBufAllocator
    implements ByteBufAllocator {
        private final ByteBufAllocator allocator;
        private final boolean direct;

        ForceTypeByteBufAllocator(ByteBufAllocator allocator, boolean direct) {
            this.allocator = allocator;
            this.direct = direct;
        }

        public ByteBuf buffer() {
            return this.direct ? this.directBuffer() : this.heapBuffer();
        }

        public ByteBuf buffer(int initialCapacity) {
            return this.direct ? this.directBuffer(initialCapacity) : this.heapBuffer(initialCapacity);
        }

        public ByteBuf buffer(int initialCapacity, int maxCapacity) {
            return this.direct ? this.directBuffer(initialCapacity, maxCapacity) : this.heapBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf ioBuffer() {
            return this.allocator.ioBuffer();
        }

        public ByteBuf ioBuffer(int initialCapacity) {
            return this.allocator.ioBuffer(initialCapacity);
        }

        public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
            return this.allocator.ioBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf heapBuffer() {
            return this.allocator.heapBuffer();
        }

        public ByteBuf heapBuffer(int initialCapacity) {
            return this.allocator.heapBuffer(initialCapacity);
        }

        public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
            return this.allocator.heapBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf directBuffer() {
            return this.allocator.directBuffer();
        }

        public ByteBuf directBuffer(int initialCapacity) {
            return this.allocator.directBuffer(initialCapacity);
        }

        public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
            return this.allocator.directBuffer(initialCapacity, maxCapacity);
        }

        public CompositeByteBuf compositeBuffer() {
            return this.direct ? this.compositeDirectBuffer() : this.compositeHeapBuffer();
        }

        public CompositeByteBuf compositeBuffer(int maxNumComponents) {
            return this.direct ? this.compositeDirectBuffer(maxNumComponents) : this.compositeHeapBuffer(maxNumComponents);
        }

        public CompositeByteBuf compositeHeapBuffer() {
            return this.allocator.compositeHeapBuffer();
        }

        public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
            return this.allocator.compositeHeapBuffer(maxNumComponents);
        }

        public CompositeByteBuf compositeDirectBuffer() {
            return this.allocator.compositeDirectBuffer();
        }

        public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
            return this.allocator.compositeDirectBuffer(maxNumComponents);
        }

        public boolean isDirectBufferPooled() {
            return this.allocator.isDirectBufferPooled();
        }

        public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
            return this.allocator.calculateNewCapacity(minNewCapacity, maxCapacity);
        }
    }
}

