/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.client.api.partition.PartitionAttributesBuilder;
import io.servicetalk.client.api.partition.PartitionedServiceDiscovererEvent;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.MultiAddressHttpClientBuilder;
import io.servicetalk.http.api.PartitionedHttpClientBuilder;
import io.servicetalk.http.api.SingleAddressHttpClientBuilder;
import io.servicetalk.http.netty.DefaultMultiAddressUrlHttpClientBuilder;
import io.servicetalk.http.netty.DefaultPartitionedHttpClientBuilder;
import io.servicetalk.http.netty.DefaultSingleAddressHttpClientBuilder;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.netty.internal.BuilderUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.function.Function;

public final class HttpClients {
    private HttpClients() {
    }

    public static MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forMultiAddressUrl() {
        return new DefaultMultiAddressUrlHttpClientBuilder(DefaultSingleAddressHttpClientBuilder.forUnknownHostAndPort());
    }

    public static MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forMultiAddressUrl(ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> serviceDiscoverer) {
        return new DefaultMultiAddressUrlHttpClientBuilder(new DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>(serviceDiscoverer));
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forSingleAddress(String host, int port) {
        return HttpClients.forSingleAddress(HostAndPort.of(host, port));
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forSingleAddress(HostAndPort address) {
        return DefaultSingleAddressHttpClientBuilder.forHostAndPort(address);
    }

    public static SingleAddressHttpClientBuilder<String, InetSocketAddress> forServiceAddress(String serviceName) {
        return DefaultSingleAddressHttpClientBuilder.forServiceAddress(serviceName);
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forResolvedAddress(String host, int port) {
        return HttpClients.forResolvedAddress(HostAndPort.of(host, port));
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forResolvedAddress(HostAndPort address) {
        return DefaultSingleAddressHttpClientBuilder.forResolvedAddress(address, BuilderUtils::toResolvedInetSocketAddress);
    }

    public static <T extends SocketAddress> SingleAddressHttpClientBuilder<T, T> forResolvedAddress(T address) {
        return DefaultSingleAddressHttpClientBuilder.forResolvedAddress(address, Function.identity());
    }

    public static <U, R> SingleAddressHttpClientBuilder<U, R> forSingleAddress(ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>> serviceDiscoverer, U address) {
        return new DefaultSingleAddressHttpClientBuilder<U, R>(address, serviceDiscoverer);
    }

    public static <U, R> PartitionedHttpClientBuilder<U, R> forPartitionedAddress(ServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>> serviceDiscoverer, U address, Function<HttpRequestMetaData, PartitionAttributesBuilder> partitionAttributesBuilderFactory) {
        return new DefaultPartitionedHttpClientBuilder(new DefaultSingleAddressHttpClientBuilder(address, new ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>>(){
            private final ListenableAsyncCloseable closeable = AsyncCloseables.emptyAsyncCloseable();

            @Override
            public Publisher<Collection<ServiceDiscovererEvent<R>>> discover(U u) {
                return Publisher.failed(new IllegalStateException("Invalid service discoverer."));
            }

            @Override
            public Completable onClose() {
                return this.closeable.onClose();
            }

            @Override
            public Completable closeAsync() {
                return this.closeable.closeAsync();
            }

            @Override
            public Completable closeAsyncGracefully() {
                return this.closeable.closeAsyncGracefully();
            }
        }), serviceDiscoverer, partitionAttributesBuilderFactory);
    }
}

