/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.util.NetUtil;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilter;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;

final class HostHeaderHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
StreamingHttpConnectionFilterFactory {
    private final CharSequence fallbackHost;

    HostHeaderHttpRequesterFilter(CharSequence fallbackHost) {
        this.fallbackHost = CharSequences.newAsciiString(NetUtil.isValidIpV6Address(fallbackHost) && fallbackHost.charAt(0) != '[' ? "[" + fallbackHost + "]" : fallbackHost.toString());
    }

    @Override
    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new StreamingHttpClientFilter(client){

            @Override
            protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
                return HostHeaderHttpRequesterFilter.this.request(delegate, request);
            }
        };
    }

    @Override
    public StreamingHttpConnectionFilter create(FilterableStreamingHttpConnection connection) {
        return new StreamingHttpConnectionFilter(connection){

            @Override
            public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
                return HostHeaderHttpRequesterFilter.this.request(this.delegate(), request);
            }
        };
    }

    @Override
    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    private Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
        return Single.defer(() -> {
            if (!HttpProtocolVersion.HTTP_1_0.equals(request.version()) && !request.headers().contains(HttpHeaderNames.HOST)) {
                request.setHeader(HttpHeaderNames.HOST, this.fallbackHost);
            }
            return delegate.request(request).shareContextOnSubscribe();
        });
    }
}

