/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.OptimizedHttp2FrameCodecBuilder;
import io.servicetalk.http.netty.ServiceTalkHttp2FrameLogger;
import io.servicetalk.logging.api.UserDataLoggerConfig;
import io.servicetalk.logging.slf4j.internal.Slf4jFixedLevelLoggers;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;

final class H2ServerParentChannelInitializer
implements io.servicetalk.transport.netty.internal.ChannelInitializer {
    private final H2ProtocolConfig config;
    private final ChannelInitializer<Http2StreamChannel> streamChannelInitializer;

    H2ServerParentChannelInitializer(H2ProtocolConfig config, ChannelInitializer<Http2StreamChannel> streamChannelInitializer) {
        this.config = config;
        this.streamChannelInitializer = streamChannelInitializer;
    }

    @Override
    public void init(Channel channel) {
        Http2FrameCodecBuilder multiplexCodecBuilder = new OptimizedHttp2FrameCodecBuilder(true).decoupleCloseAndGoAway(true).autoAckPingFrame(false).gracefulShutdownTimeoutMillis(-1L);
        BiPredicate<CharSequence, CharSequence> headersSensitivityDetector = this.config.headersSensitivityDetector();
        multiplexCodecBuilder.headerSensitivityDetector(headersSensitivityDetector::test);
        H2ServerParentChannelInitializer.initFrameLogger(multiplexCodecBuilder, this.config.frameLoggerConfig());
        channel.pipeline().addLast(multiplexCodecBuilder.build(), new Http2MultiplexHandler(this.streamChannelInitializer));
    }

    static void initFrameLogger(Http2FrameCodecBuilder multiplexCodecBuilder, @Nullable UserDataLoggerConfig frameLoggerConfig) {
        if (frameLoggerConfig != null) {
            multiplexCodecBuilder.frameLogger(new ServiceTalkHttp2FrameLogger(Slf4jFixedLevelLoggers.newLogger(frameLoggerConfig.loggerName(), frameLoggerConfig.logLevel()), frameLoggerConfig.logUserData()));
        }
    }
}

