/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http.HttpScheme;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.client.api.ClientGroup;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.SubscribableCompletable;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.MultiAddressHttpClientBuilder;
import io.servicetalk.http.api.RedirectConfig;
import io.servicetalk.http.api.StreamingHttpClient;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.api.StreamingHttpResponseFactory;
import io.servicetalk.http.netty.DefaultSingleAddressHttpClientBuilder;
import io.servicetalk.http.netty.FilterableClientToClient;
import io.servicetalk.http.utils.RedirectingHttpRequesterFilter;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.ClientSslConfigBuilder;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.transport.api.IoExecutor;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultMultiAddressUrlHttpClientBuilder
implements MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMultiAddressUrlHttpClientBuilder.class);
    private static final String HTTPS_SCHEME = HttpScheme.HTTPS.toString();
    private final DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> builderTemplate;
    @Nullable
    private RedirectConfig redirectConfig;
    @Nullable
    private MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> singleAddressInitializer;

    DefaultMultiAddressUrlHttpClientBuilder(DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> builderTemplate) {
        this.builderTemplate = Objects.requireNonNull(builderTemplate);
    }

    @Override
    public StreamingHttpClient buildStreaming() {
        CompositeCloseable closeables = AsyncCloseables.newCompositeCloseable();
        try {
            DefaultSingleAddressHttpClientBuilder.HttpClientBuildContext<HostAndPort, InetSocketAddress> buildContext = this.builderTemplate.copyBuildCtx();
            ClientFactory clientFactory = new ClientFactory(buildContext.builder, this.singleAddressInitializer);
            HttpExecutionContext executionContext = buildContext.builder.executionContextBuilder.build();
            CachingKeyFactory keyFactory = closeables.prepend(new CachingKeyFactory());
            FilterableStreamingHttpClient urlClient = closeables.prepend(new StreamingUrlHttpClient(executionContext, clientFactory, keyFactory, DefaultSingleAddressHttpClientBuilder.defaultReqRespFactory(buildContext.httpConfig().asReadOnly(), executionContext.bufferAllocator())));
            urlClient = this.redirectConfig == null ? urlClient : new RedirectingHttpRequesterFilter(this.redirectConfig).create(urlClient);
            HttpExecutionStrategy computedStrategy = buildContext.builder.computeChainStrategy(executionContext.executionStrategy());
            LOGGER.debug("Client created with base strategy {} \u2192 computed strategy {}", (Object)executionContext.executionStrategy(), (Object)computedStrategy);
            return new FilterableClientToClient(urlClient, computedStrategy);
        }
        catch (Throwable t) {
            closeables.closeAsync().subscribe();
            throw t;
        }
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> ioExecutor(IoExecutor ioExecutor) {
        this.builderTemplate.ioExecutor(ioExecutor);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> executor(Executor executor) {
        this.builderTemplate.executor(executor);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> bufferAllocator(BufferAllocator allocator) {
        this.builderTemplate.bufferAllocator(allocator);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> executionStrategy(HttpExecutionStrategy strategy) {
        this.builderTemplate.executionStrategy(strategy);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> initializer(MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> initializer) {
        this.singleAddressInitializer = Objects.requireNonNull(initializer);
        return this;
    }

    @Override
    public MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> followRedirects(RedirectConfig config) {
        this.redirectConfig = Objects.requireNonNull(config);
        return this;
    }

    private static final class StreamingUrlHttpClient
    implements FilterableStreamingHttpClient {
        private final HttpExecutionContext executionContext;
        private final StreamingHttpRequestResponseFactory reqRespFactory;
        private final ClientGroup<UrlKey, FilterableStreamingHttpClient> group;
        private final CachingKeyFactory keyFactory;
        private final ListenableAsyncCloseable closeable;

        StreamingUrlHttpClient(HttpExecutionContext executionContext, Function<UrlKey, FilterableStreamingHttpClient> clientFactory, CachingKeyFactory keyFactory, StreamingHttpRequestResponseFactory reqRespFactory) {
            this.reqRespFactory = Objects.requireNonNull(reqRespFactory);
            this.group = ClientGroup.from(clientFactory);
            this.keyFactory = keyFactory;
            CompositeCloseable compositeCloseable = AsyncCloseables.newCompositeCloseable();
            compositeCloseable.append(this.group);
            compositeCloseable.append(keyFactory);
            this.closeable = AsyncCloseables.toListenableAsyncCloseable(compositeCloseable);
            this.executionContext = Objects.requireNonNull(executionContext);
        }

        private FilterableStreamingHttpClient selectClient(HttpRequestMetaData metaData) throws MalformedURLException {
            return this.group.get(this.keyFactory.get(metaData));
        }

        @Override
        public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
            return Single.defer(() -> {
                try {
                    return this.selectClient(metaData).reserveConnection(metaData).shareContextOnSubscribe();
                }
                catch (Throwable t) {
                    return Single.failed(t).shareContextOnSubscribe();
                }
            });
        }

        @Override
        public Single<StreamingHttpResponse> request(StreamingHttpRequest request) {
            return Single.defer(() -> {
                try {
                    return this.selectClient(request).request(request).shareContextOnSubscribe();
                }
                catch (Throwable t) {
                    return Single.failed(t).shareContextOnSubscribe();
                }
            });
        }

        @Override
        public HttpExecutionContext executionContext() {
            return this.executionContext;
        }

        @Override
        public StreamingHttpResponseFactory httpResponseFactory() {
            return this.reqRespFactory;
        }

        @Override
        public Completable onClose() {
            return this.closeable.onClose();
        }

        @Override
        public Completable closeAsync() {
            return this.closeable.closeAsync();
        }

        @Override
        public Completable closeAsyncGracefully() {
            return this.closeable.closeAsyncGracefully();
        }

        @Override
        public StreamingHttpRequest newRequest(HttpRequestMethod method, String requestTarget) {
            return this.reqRespFactory.newRequest(method, requestTarget);
        }
    }

    private static final class ClientFactory
    implements Function<UrlKey, FilterableStreamingHttpClient> {
        private static final ClientSslConfig DEFAULT_CLIENT_SSL_CONFIG = new ClientSslConfigBuilder().build();
        private final DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> builderTemplate;
        @Nullable
        private final MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> singleAddressInitializer;

        ClientFactory(DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> builderTemplate, @Nullable MultiAddressHttpClientBuilder.SingleAddressInitializer<HostAndPort, InetSocketAddress> singleAddressInitializer) {
            this.builderTemplate = builderTemplate;
            this.singleAddressInitializer = singleAddressInitializer;
        }

        @Override
        public StreamingHttpClient apply(UrlKey urlKey) {
            DefaultSingleAddressHttpClientBuilder.HttpClientBuildContext<HostAndPort, InetSocketAddress> buildContext = this.builderTemplate.copyBuildCtx(urlKey.hostAndPort);
            if (HTTPS_SCHEME.equalsIgnoreCase(urlKey.scheme)) {
                buildContext.builder.sslConfig(DEFAULT_CLIENT_SSL_CONFIG);
            }
            if (this.singleAddressInitializer != null) {
                this.singleAddressInitializer.initialize(urlKey.scheme, urlKey.hostAndPort, buildContext.builder);
            }
            return buildContext.build();
        }
    }

    private static final class UrlKey {
        final String scheme;
        final HostAndPort hostAndPort;

        UrlKey(String scheme, HostAndPort hostAndPort) {
            this.scheme = scheme;
            this.hostAndPort = hostAndPort;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UrlKey urlKey = (UrlKey)o;
            return this.scheme.equals(urlKey.scheme) && this.hostAndPort.equals(urlKey.hostAndPort);
        }

        public int hashCode() {
            return 31 * this.hostAndPort.hashCode() + this.scheme.hashCode();
        }
    }

    private static final class CachingKeyFactory
    implements AsyncCloseable {
        private final ConcurrentMap<String, UrlKey> urlKeyCache = new ConcurrentHashMap<String, UrlKey>();

        private CachingKeyFactory() {
        }

        public UrlKey get(HttpRequestMetaData metaData) throws MalformedURLException {
            String host = metaData.host();
            if (host == null) {
                throw new MalformedURLException("Request-target does not contain target host address: " + metaData.requestTarget() + ", expected absolute-form URL");
            }
            String scheme = metaData.scheme();
            if (scheme == null) {
                throw new MalformedURLException("Request-target does not contains scheme: " + metaData.requestTarget() + ", expected absolute-form URL");
            }
            int parsedPort = metaData.port();
            int port = parsedPort >= 0 ? parsedPort : (HTTPS_SCHEME.equalsIgnoreCase(scheme) ? HttpScheme.HTTPS : HttpScheme.HTTP).port();
            metaData.requestTarget(CachingKeyFactory.absoluteToRelativeFormRequestTarget(metaData.requestTarget(), scheme, host));
            String key = scheme + ':' + host + ':' + port;
            UrlKey urlKey = (UrlKey)this.urlKeyCache.get(key);
            return urlKey != null ? urlKey : this.urlKeyCache.computeIfAbsent(key, ignore -> new UrlKey(scheme, HostAndPort.of(host, port)));
        }

        private static String absoluteToRelativeFormRequestTarget(String requestTarget, String scheme, String host) {
            int fromIndex = scheme.length() + 3 + host.length();
            int relativeReferenceIdx = requestTarget.indexOf(47, fromIndex);
            return relativeReferenceIdx < 0 ? "/" : requestTarget.substring(relativeReferenceIdx);
        }

        @Override
        public Completable closeAsync() {
            return new SubscribableCompletable(){

                @Override
                protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                    urlKeyCache.clear();
                    SubscriberUtils.deliverCompleteFromSource(subscriber);
                }
            };
        }
    }
}

