/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.TerminalSignalConsumer;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class BeforeFinallyPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final TerminalSignalConsumer doFinally;

    BeforeFinallyPublisher(Publisher<T> original, TerminalSignalConsumer doFinally) {
        super(original);
        this.doFinally = Objects.requireNonNull(doFinally);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new BeforeFinallyPublisherSubscriber<T>(subscriber, this.doFinally);
    }

    private static final class BeforeFinallyPublisherSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private final PublisherSource.Subscriber<? super T> original;
        private final TerminalSignalConsumer doFinally;
        private static final AtomicIntegerFieldUpdater<BeforeFinallyPublisherSubscriber> doneUpdater = AtomicIntegerFieldUpdater.newUpdater(BeforeFinallyPublisherSubscriber.class, "done");
        private volatile int done;

        BeforeFinallyPublisherSubscriber(PublisherSource.Subscriber<? super T> original, TerminalSignalConsumer doFinally) {
            this.original = original;
            this.doFinally = doFinally;
        }

        @Override
        public void onSubscribe(final PublisherSource.Subscription s) {
            this.original.onSubscribe(new PublisherSource.Subscription(){

                @Override
                public void request(long n) {
                    s.request(n);
                }

                @Override
                public void cancel() {
                    try {
                        if (doneUpdater.compareAndSet(this, 0, 1)) {
                            doFinally.cancel();
                        }
                    }
                    finally {
                        s.cancel();
                    }
                }
            });
        }

        @Override
        public void onNext(T t) {
            this.original.onNext(t);
        }

        @Override
        public void onComplete() {
            try {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.onComplete();
                }
            }
            catch (Throwable err) {
                this.original.onError(err);
                return;
            }
            this.original.onComplete();
        }

        @Override
        public void onError(Throwable cause) {
            try {
                if (doneUpdater.compareAndSet(this, 0, 1)) {
                    this.doFinally.onError(cause);
                }
            }
            catch (Throwable err) {
                err.addSuppressed(cause);
                this.original.onError(err);
                return;
            }
            this.original.onError(cause);
        }
    }
}

