/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.utils.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;

public final class ServiceLoaderUtils {
    private ServiceLoaderUtils() {
    }

    public static <T> List<T> loadProviders(Class<T> clazz, ClassLoader classLoader, Logger logger) {
        ArrayList<T> list = new ArrayList<T>(0);
        for (T provider : ServiceLoader.load(clazz, classLoader)) {
            list.add(provider);
        }
        logger.debug("Registered {} {}(s): {}", list.size(), clazz.getSimpleName(), list);
        return list.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(list);
    }
}

