/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.util.ReferenceCountUtil;
import io.servicetalk.transport.api.ClientSslConfig;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.ConnectionObserverInitializer;
import io.servicetalk.transport.netty.internal.CopyByteBufHandlerChannelInitializer;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.transport.netty.internal.SslContextFactory;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

final class SslUtils {
    private SslUtils() {
    }

    static SslHandler newClientSslHandler(SslContext context, ClientSslConfig sslConfig, Channel channel) {
        SslHandler handler = context.newHandler((ByteBufAllocator)CopyByteBufHandlerChannelInitializer.POOLED_ALLOCATOR, sslConfig.peerHost(), sslConfig.peerPort());
        SslUtils.observeHandshakeCompletion(handler, channel);
        SslUtils.setHandshakeTimeout(handler, context);
        SSLEngine engine = handler.engine();
        try {
            String hostnameVerificationAlgorithm = sslConfig.hostnameVerificationAlgorithm();
            String sniHostname = sslConfig.sniHostname();
            SSLParameters parameters = engine.getSSLParameters();
            if (hostnameVerificationAlgorithm != null) {
                parameters.setEndpointIdentificationAlgorithm(hostnameVerificationAlgorithm);
            }
            if (sniHostname != null) {
                parameters.setServerNames(Collections.singletonList(new SNIHostName(sniHostname)));
            }
            engine.setSSLParameters(parameters);
        }
        catch (Throwable cause) {
            ReferenceCountUtil.release(engine);
            throw cause;
        }
        return handler;
    }

    static SslHandler newServerSslHandler(SslContext context, Channel channel) {
        SslHandler handler = context.newHandler(CopyByteBufHandlerChannelInitializer.POOLED_ALLOCATOR);
        SslUtils.observeHandshakeCompletion(handler, channel);
        SslUtils.setHandshakeTimeout(handler, context);
        return handler;
    }

    private static void observeHandshakeCompletion(SslHandler sslHandler, Channel channel) {
        ConnectionObserverInitializer.ConnectionObserverHandler observerHandler = channel.pipeline().get(ConnectionObserverInitializer.ConnectionObserverHandler.class);
        if (observerHandler == null) {
            return;
        }
        sslHandler.handshakeFuture().addListener(f -> {
            ConnectionObserver.SecurityHandshakeObserver handshakeObserver = SslUtils.getHandshakeObserver(observerHandler);
            Throwable cause = f.cause();
            if (cause == null) {
                handshakeObserver.handshakeComplete(sslHandler.engine().getSession());
            } else {
                ChannelCloseUtils.assignConnectionError(channel, cause);
                handshakeObserver.handshakeFailed(cause);
            }
        });
    }

    private static ConnectionObserver.SecurityHandshakeObserver getHandshakeObserver(ConnectionObserverInitializer.ConnectionObserverHandler handler) {
        ConnectionObserver.SecurityHandshakeObserver handshakeObserver = handler.handshakeObserver();
        if (handshakeObserver == null) {
            return NoopTransportObserver.NoopSecurityHandshakeObserver.INSTANCE;
        }
        return handshakeObserver;
    }

    private static void setHandshakeTimeout(SslHandler handler, SslContext context) {
        handler.setHandshakeTimeoutMillis(context.attributes().attr(SslContextFactory.HANDSHAKE_TIMEOUT_MILLIS).get());
    }

    static ApplicationProtocolConfig nettyApplicationProtocol(@Nullable List<String> supportedAlpnProtocols) {
        if (supportedAlpnProtocols == null || supportedAlpnProtocols.isEmpty()) {
            return ApplicationProtocolConfig.DISABLED;
        }
        return new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, (Iterable<String>)supportedAlpnProtocols);
    }

    @Nullable
    static SslProvider toNettySslProvider(@Nullable io.servicetalk.transport.api.SslProvider provider, boolean alpn) {
        if (provider == null) {
            if (alpn) {
                if (SslProvider.isAlpnSupported(SslProvider.OPENSSL)) {
                    return SslProvider.OPENSSL;
                }
                if (SslProvider.isAlpnSupported(SslProvider.JDK)) {
                    return SslProvider.JDK;
                }
                throw new IllegalStateException("ALPN configured but not supported by the current classpath: add OPENSSL support (https://netty.io/wiki/forked-tomcat-native.html) or configure ALPN for JDK (https://www.eclipse.org/jetty/documentation/current/alpn-chapter.html)");
            }
            return null;
        }
        switch (provider) {
            case JDK: {
                if (alpn && !SslProvider.isAlpnSupported(SslProvider.JDK)) {
                    throw new IllegalStateException("ALPN configured but not supported by the current classpath. For more information, see https://www.eclipse.org/jetty/documentation/current/alpn-chapter.html");
                }
                return SslProvider.JDK;
            }
            case OPENSSL: {
                OpenSsl.ensureAvailability();
                if (alpn && !SslProvider.isAlpnSupported(SslProvider.OPENSSL)) {
                    throw new IllegalStateException("ALPN configured but not supported by installed version of OpenSSL");
                }
                return SslProvider.OPENSSL;
            }
        }
        throw new Error("Unknown SSL provider specified: " + (Object)((Object)provider));
    }
}

