/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.concurrent.Future;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.SslConfig;
import io.servicetalk.transport.netty.internal.ConnectionObserverInitializer;
import io.servicetalk.transport.netty.internal.DeferSslHandler;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyPipelineSslUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyPipelineSslUtils.class);

    private NettyPipelineSslUtils() {
    }

    @Deprecated
    public static boolean isSslEnabled(ChannelPipeline pipeline) {
        return pipeline.get(SslHandler.class) != null || pipeline.get(SniHandler.class) != null;
    }

    @Nullable
    @Deprecated
    public static SSLSession extractSslSessionAndReport(@Nullable SslConfig sslConfig, ChannelPipeline pipeline, ConnectionObserver connectionObserver) {
        if (sslConfig == null) {
            assert (NettyPipelineSslUtils.noSslHandlers(pipeline)) : "No SslConfig configured but SSL-related handler found in the pipeline";
            return null;
        }
        SslHandler sslHandler = pipeline.get(SslHandler.class);
        if (sslHandler == null) {
            if (pipeline.get(DeferSslHandler.class) != null) {
                return null;
            }
            throw NettyPipelineSslUtils.unableToFindSslHandler();
        }
        Future<Channel> handshakeFuture = sslHandler.handshakeFuture();
        if (handshakeFuture.isDone()) {
            ConnectionObserver.SecurityHandshakeObserver observer = NettyPipelineSslUtils.lookForHandshakeObserver(pipeline, connectionObserver != NoopTransportObserver.NoopConnectionObserver.INSTANCE);
            Throwable cause = handshakeFuture.cause();
            if (cause != null) {
                if (observer != null) {
                    observer.handshakeFailed(cause);
                }
                return (SSLSession)ThrowableUtils.throwException(cause);
            }
            return NettyPipelineSslUtils.getSslSession(sslHandler, observer);
        }
        return null;
    }

    @Nullable
    public static SSLSession extractSslSession(@Nullable SslConfig sslConfig, ChannelPipeline pipeline) {
        return NettyPipelineSslUtils.extractSslSessionAndReport(sslConfig, pipeline, NoopTransportObserver.NoopConnectionObserver.INSTANCE);
    }

    @Nullable
    @Deprecated
    public static SSLSession extractSslSessionAndReport(ChannelPipeline pipeline, SslHandshakeCompletionEvent sslEvent, Consumer<Throwable> failureConsumer, boolean shouldReport) {
        ConnectionObserver.SecurityHandshakeObserver observer = NettyPipelineSslUtils.lookForHandshakeObserver(pipeline, shouldReport);
        if (sslEvent.isSuccess()) {
            SslHandler sslHandler = pipeline.get(SslHandler.class);
            if (sslHandler != null) {
                return NettyPipelineSslUtils.getSslSession(sslHandler, observer);
            }
            NettyPipelineSslUtils.deliverFailureCause(failureConsumer, NettyPipelineSslUtils.unableToFindSslHandler(), observer);
        } else {
            NettyPipelineSslUtils.deliverFailureCause(failureConsumer, sslEvent.cause(), observer);
        }
        return null;
    }

    @Nullable
    public static SSLSession extractSslSession(ChannelPipeline pipeline, SslHandshakeCompletionEvent sslEvent, Consumer<Throwable> failureConsumer) {
        return NettyPipelineSslUtils.extractSslSessionAndReport(pipeline, sslEvent, failureConsumer, false);
    }

    private static boolean noSslHandlers(ChannelPipeline pipeline) {
        return pipeline.get(SslHandler.class) == null && pipeline.get(DeferSslHandler.class) == null && pipeline.get(SniHandler.class) == null;
    }

    private static SSLSession getSslSession(SslHandler sslHandler, @Nullable ConnectionObserver.SecurityHandshakeObserver observer) {
        SSLSession session = sslHandler.engine().getSession();
        if (observer != null) {
            observer.handshakeComplete(session);
        }
        return session;
    }

    private static void deliverFailureCause(Consumer<Throwable> failureConsumer, Throwable cause, @Nullable ConnectionObserver.SecurityHandshakeObserver securityObserver) {
        if (securityObserver != null) {
            securityObserver.handshakeFailed(cause);
        }
        failureConsumer.accept(cause);
    }

    @Nullable
    private static ConnectionObserver.SecurityHandshakeObserver lookForHandshakeObserver(ChannelPipeline pipeline, boolean shouldReport) {
        if (!shouldReport) {
            return null;
        }
        ConnectionObserverInitializer.ConnectionObserverHandler handler = pipeline.get(ConnectionObserverInitializer.ConnectionObserverHandler.class);
        if (handler == null) {
            LOGGER.warn("Expected to report the handshake completion event, but unable to find {} in the pipeline.", (Object)ConnectionObserverInitializer.ConnectionObserverHandler.class);
            return null;
        }
        ConnectionObserver.SecurityHandshakeObserver handshakeObserver = handler.handshakeObserver();
        if (handshakeObserver == null) {
            LOGGER.warn("Expected to report the handshake completion event, but {} was not initialized.", (Object)ConnectionObserver.SecurityHandshakeObserver.class);
            return null;
        }
        return handshakeObserver;
    }

    private static IllegalStateException unableToFindSslHandler() {
        return new IllegalStateException("Unable to find " + SslHandler.class.getName() + " in the pipeline.");
    }
}

