/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.transport.netty.internal.BatchFlush;
import io.servicetalk.transport.netty.internal.FlushOnEach;
import io.servicetalk.transport.netty.internal.FlushOnEnd;
import io.servicetalk.transport.netty.internal.FlushStrategy;

public final class FlushStrategies {
    private FlushStrategies() {
    }

    public static FlushStrategy defaultFlushStrategy() {
        return FlushStrategies.flushOnEach();
    }

    public static FlushStrategy flushOnEach() {
        return FlushOnEach.FLUSH_ON_EACH;
    }

    public static FlushStrategy batchFlush(int batchSize, Publisher<?> durationBoundaries) {
        return new BatchFlush(durationBoundaries, batchSize);
    }

    public static FlushStrategy flushWith(Publisher<?> flushBoundaries) {
        return FlushStrategies.batchFlush(Integer.MAX_VALUE, flushBoundaries);
    }

    public static FlushStrategy flushOnEnd() {
        return FlushOnEnd.FLUSH_ON_END;
    }
}

