/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.channel.Channel;
import io.servicetalk.logging.api.UserDataLoggerConfig;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpServerConfig;
import io.servicetalk.tcp.netty.internal.TcpConnectionInfo;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.ConnectionObserverInitializer;
import io.servicetalk.transport.netty.internal.ExecutionContextUtils;
import io.servicetalk.transport.netty.internal.IdleTimeoutInitializer;
import io.servicetalk.transport.netty.internal.NoopTransportObserver;
import io.servicetalk.transport.netty.internal.SniServerChannelInitializer;
import io.servicetalk.transport.netty.internal.SslServerChannelInitializer;
import io.servicetalk.transport.netty.internal.WireLoggingInitializer;
import javax.annotation.Nullable;

public class TcpServerChannelInitializer
implements ChannelInitializer {
    private final ChannelInitializer delegate;

    @Deprecated
    public TcpServerChannelInitializer(ReadOnlyTcpServerConfig config, ConnectionObserver observer) {
        this(config, observer, null);
    }

    public TcpServerChannelInitializer(ReadOnlyTcpServerConfig config, ConnectionObserver observer, ExecutionContext<?> executionContext) {
        ChannelInitializer delegate = ChannelInitializer.defaultInitializer();
        if (observer != NoopTransportObserver.NoopConnectionObserver.INSTANCE) {
            delegate = delegate.andThen(new ConnectionObserverInitializer(observer, channel -> new TcpConnectionInfo((Channel)channel, executionContext == null ? null : ExecutionContextUtils.channelExecutionContext(channel, executionContext), config.sslConfig(), config.idleTimeoutMs()), config.sslConfig() != null, false));
        }
        if (config.idleTimeoutMs() > 0L) {
            delegate = delegate.andThen(new IdleTimeoutInitializer(config.idleTimeoutMs()));
        }
        if (config.sniMapping() != null) {
            assert (config.sslConfig() != null);
            assert (config.sslContext() != null);
            delegate = delegate.andThen(new SniServerChannelInitializer(config.sniMapping(), config.sniMaxClientHelloLength(), config.sniClientHelloTimeout().toMillis()));
        } else if (config.sslContext() != null) {
            assert (config.sslConfig() != null);
            delegate = delegate.andThen(new SslServerChannelInitializer(config.sslContext()));
        }
        this.delegate = TcpServerChannelInitializer.initWireLogger(delegate, config.wireLoggerConfig());
    }

    @Override
    public void init(Channel channel) {
        this.delegate.init(channel);
    }

    static ChannelInitializer initWireLogger(ChannelInitializer delegate, @Nullable UserDataLoggerConfig wireLoggerConfig) {
        if (wireLoggerConfig == null) {
            return delegate;
        }
        return delegate.andThen(new WireLoggingInitializer(wireLoggerConfig.loggerName(), wireLoggerConfig.logLevel(), wireLoggerConfig.logUserData()));
    }
}

