/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.tcp.netty.internal;

import io.netty.channel.Channel;
import io.servicetalk.transport.api.ConnectionInfo;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.SslConfig;
import io.servicetalk.transport.netty.internal.SocketOptionUtils;
import java.net.SocketAddress;
import java.net.SocketOption;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;

final class TcpConnectionInfo
implements ConnectionInfo {
    private static final ConnectionInfo.Protocol TCP_PROTOCOL = () -> "TCP";
    private final Channel channel;
    private final ExecutionContext<?> executionContext;
    @Nullable
    private final SslConfig sslConfig;
    private final long idleTimeoutMs;

    TcpConnectionInfo(Channel channel, ExecutionContext<?> executionContext, @Nullable SslConfig sslConfig, long idleTimeoutMs) {
        this.channel = channel;
        this.executionContext = executionContext;
        this.sslConfig = sslConfig;
        this.idleTimeoutMs = idleTimeoutMs;
    }

    @Override
    public SocketAddress localAddress() {
        return this.channel.localAddress();
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.channel.remoteAddress();
    }

    @Override
    public ExecutionContext<?> executionContext() {
        return this.executionContext;
    }

    @Override
    @Nullable
    public SslConfig sslConfig() {
        return this.sslConfig;
    }

    @Override
    @Nullable
    public SSLSession sslSession() {
        return null;
    }

    @Override
    @Nullable
    public <T> T socketOption(SocketOption<T> option) {
        return SocketOptionUtils.getOption(option, this.channel.config(), this.idleTimeoutMs);
    }

    @Override
    public ConnectionInfo.Protocol protocol() {
        return TCP_PROTOCOL;
    }

    public String toString() {
        return this.channel.toString();
    }
}

