/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.loadbalancer.BaseHostSelector;
import io.servicetalk.loadbalancer.Host;
import java.util.List;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class RoundRobinSelector<ResolvedAddress, C extends LoadBalancedConnection>
extends BaseHostSelector<ResolvedAddress, C> {
    private static final AtomicIntegerFieldUpdater<RoundRobinSelector> indexUpdater = AtomicIntegerFieldUpdater.newUpdater(RoundRobinSelector.class, "index");
    private volatile int index;

    RoundRobinSelector(String targetResource) {
        super(targetResource);
    }

    @Override
    public Single<C> selectConnection(List<Host<ResolvedAddress, C>> usedHosts, Predicate<C> selector, @Nullable ContextMap context, boolean forceNewConnectionAndReserve) {
        int cursor = (indexUpdater.getAndIncrement(this) & Integer.MAX_VALUE) % usedHosts.size();
        Host<ResolvedAddress, C> pickedHost = null;
        for (int i = 0; i < usedHosts.size(); ++i) {
            C connection;
            int localCursor = (cursor + i) % usedHosts.size();
            Host<ResolvedAddress, C> host = usedHosts.get(localCursor);
            assert (host != null) : "Host can't be null.";
            if (!forceNewConnectionAndReserve && (connection = host.pickConnection(selector, context)) != null) {
                return Single.succeeded(connection);
            }
            if (!host.isActiveAndHealthy()) continue;
            pickedHost = host;
            break;
        }
        if (pickedHost == null) {
            return this.noActiveHosts(usedHosts);
        }
        return pickedHost.newConnection(selector, forceNewConnectionAndReserve, context);
    }
}

