/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.LoadBalancerFactory;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.DefaultThreadFactory;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.loadbalancer.HealthCheckConfig;
import io.servicetalk.loadbalancer.NewRoundRobinLoadBalancer;
import io.servicetalk.loadbalancer.NormalizedTimeSourceExecutor;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancer;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancerBuilder;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.utils.internal.DurationUtils;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Deprecated
public final class RoundRobinLoadBalancerFactory<ResolvedAddress, C extends LoadBalancedConnection>
implements LoadBalancerFactory<ResolvedAddress, C> {
    private static final Duration DEFAULT_HEALTH_CHECK_INTERVAL = Duration.ofSeconds(5L);
    private static final Duration DEFAULT_HEALTH_CHECK_JITTER = Duration.ofSeconds(3L);
    static final Duration DEFAULT_HEALTH_CHECK_RESUBSCRIBE_INTERVAL = Duration.ofSeconds(10L);
    static final int DEFAULT_HEALTH_CHECK_FAILED_CONNECTIONS_THRESHOLD = 5;
    private final String id;
    private final int linearSearchSpace;
    private final boolean useNewRoundRobin;
    @Nullable
    private final HealthCheckConfig healthCheckConfig;

    private RoundRobinLoadBalancerFactory(String id, int linearSearchSpace, boolean useNewRoundRobin, @Nullable HealthCheckConfig healthCheckConfig) {
        this.id = id;
        this.linearSearchSpace = linearSearchSpace;
        this.useNewRoundRobin = useNewRoundRobin;
        this.healthCheckConfig = healthCheckConfig;
    }

    @Override
    @Deprecated
    public <T extends C> LoadBalancer<T> newLoadBalancer(String targetResource, Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, T> connectionFactory) {
        return this.useNewRoundRobin ? new NewRoundRobinLoadBalancer<ResolvedAddress, T>(this.id, targetResource, eventPublisher, connectionFactory, this.linearSearchSpace, this.healthCheckConfig) : new RoundRobinLoadBalancer<ResolvedAddress, T>(this.id, targetResource, eventPublisher, connectionFactory, this.linearSearchSpace, this.healthCheckConfig);
    }

    @Override
    public LoadBalancer<C> newLoadBalancer(Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, C> connectionFactory, String targetResource) {
        return this.useNewRoundRobin ? new NewRoundRobinLoadBalancer<ResolvedAddress, C>(this.id, targetResource, eventPublisher, connectionFactory, this.linearSearchSpace, this.healthCheckConfig) : new RoundRobinLoadBalancer<ResolvedAddress, C>(this.id, targetResource, eventPublisher, connectionFactory, this.linearSearchSpace, this.healthCheckConfig);
    }

    @Override
    public ExecutionStrategy requiredOffloads() {
        return ExecutionStrategy.offloadNone();
    }

    static final class SharedExecutor {
        private static final Executor INSTANCE = new NormalizedTimeSourceExecutor(Executors.from(new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DefaultThreadFactory("round-robin-load-balancer-executor"))));

        private SharedExecutor() {
        }

        static Executor getInstance() {
            return INSTANCE;
        }
    }

    @Deprecated
    public static final class Builder<ResolvedAddress, C extends LoadBalancedConnection>
    implements RoundRobinLoadBalancerBuilder<ResolvedAddress, C> {
        private final String id;
        private int linearSearchSpace = 16;
        private boolean useNewRoundRobin;
        @Nullable
        private Executor backgroundExecutor;
        private Duration healthCheckInterval = RoundRobinLoadBalancerFactory.access$000();
        private Duration healthCheckJitter = RoundRobinLoadBalancerFactory.access$100();
        private int healthCheckFailedConnectionsThreshold = 5;
        private long healthCheckResubscribeLowerBound = DEFAULT_HEALTH_CHECK_RESUBSCRIBE_INTERVAL.minus(RoundRobinLoadBalancerFactory.access$100()).toNanos();
        private long healthCheckResubscribeUpperBound = DEFAULT_HEALTH_CHECK_RESUBSCRIBE_INTERVAL.plus(RoundRobinLoadBalancerFactory.access$100()).toNanos();

        @Deprecated
        public Builder() {
            this("undefined");
        }

        Builder(String id) {
            if (id.isEmpty()) {
                throw new IllegalArgumentException("ID can not be empty");
            }
            this.id = id;
        }

        @Override
        public Builder<ResolvedAddress, C> linearSearchSpace(int linearSearchSpace) {
            if (linearSearchSpace < 0) {
                throw new IllegalArgumentException("linearSearchSpace: " + linearSearchSpace + " (expected >=0)");
            }
            this.linearSearchSpace = linearSearchSpace;
            return this;
        }

        RoundRobinLoadBalancerBuilder<ResolvedAddress, C> useNewRoundRobin(boolean useNewRoundRobin) {
            this.useNewRoundRobin = useNewRoundRobin;
            return this;
        }

        @Override
        public Builder<ResolvedAddress, C> backgroundExecutor(Executor backgroundExecutor) {
            this.backgroundExecutor = new NormalizedTimeSourceExecutor(backgroundExecutor);
            return this;
        }

        @Deprecated
        public Builder<ResolvedAddress, C> healthCheckInterval(Duration interval) {
            return this.healthCheckInterval(interval, interval.compareTo(DEFAULT_HEALTH_CHECK_INTERVAL) < 0 ? interval.dividedBy(2L) : DEFAULT_HEALTH_CHECK_JITTER);
        }

        @Override
        public Builder<ResolvedAddress, C> healthCheckInterval(Duration interval, Duration jitter) {
            Builder.validate(interval, jitter);
            this.healthCheckInterval = interval;
            this.healthCheckJitter = jitter;
            return this;
        }

        @Override
        public Builder<ResolvedAddress, C> healthCheckResubscribeInterval(Duration interval, Duration jitter) {
            Builder.validate(interval, jitter);
            this.healthCheckResubscribeLowerBound = interval.minus(jitter).toNanos();
            this.healthCheckResubscribeUpperBound = interval.plus(jitter).toNanos();
            return this;
        }

        private static void validate(Duration interval, Duration jitter) {
            DurationUtils.ensurePositive(interval, "interval");
            DurationUtils.ensureNonNegative(jitter, "jitter");
            Duration lowerBound = interval.minus(jitter);
            if (!DurationUtils.isPositive(lowerBound)) {
                throw new IllegalArgumentException("interval (" + interval + ") minus jitter (" + jitter + ") must be greater than 0, current=" + lowerBound);
            }
            Duration upperBound = interval.plus(jitter);
            if (!DurationUtils.isPositive(upperBound)) {
                throw new IllegalArgumentException("interval (" + interval + ") plus jitter (" + jitter + ") must not overflow, current=" + upperBound);
            }
        }

        @Override
        public Builder<ResolvedAddress, C> healthCheckFailedConnectionsThreshold(int threshold) {
            if (threshold == 0) {
                throw new IllegalArgumentException("Health check failed connections threshold should not be 0");
            }
            this.healthCheckFailedConnectionsThreshold = threshold;
            return this;
        }

        @Override
        public RoundRobinLoadBalancerFactory<ResolvedAddress, C> build() {
            if (this.healthCheckFailedConnectionsThreshold < 0) {
                return new RoundRobinLoadBalancerFactory(this.id, this.linearSearchSpace, this.useNewRoundRobin, null);
            }
            HealthCheckConfig healthCheckConfig = new HealthCheckConfig(this.backgroundExecutor == null ? SharedExecutor.getInstance() : this.backgroundExecutor, this.healthCheckInterval, this.healthCheckJitter, this.healthCheckFailedConnectionsThreshold, this.healthCheckResubscribeLowerBound, this.healthCheckResubscribeUpperBound);
            return new RoundRobinLoadBalancerFactory(this.id, this.linearSearchSpace, this.useNewRoundRobin, healthCheckConfig);
        }
    }
}

