/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.loadbalancer.BaseHostSelector;
import io.servicetalk.loadbalancer.Host;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class P2CSelector<ResolvedAddress, C extends LoadBalancedConnection>
extends BaseHostSelector<ResolvedAddress, C> {
    @Nullable
    private final Random random;
    private final int maxEffort;

    P2CSelector(String targetResource, int maxEffort, @Nullable Random random) {
        super(targetResource);
        this.maxEffort = maxEffort;
        this.random = random;
    }

    @Override
    public Single<C> selectConnection(@Nonnull List<Host<ResolvedAddress, C>> hosts, @Nonnull Predicate<C> selector, @Nullable ContextMap context, boolean forceNewConnectionAndReserve) {
        int size = hosts.size();
        switch (size) {
            case 0: {
                throw new AssertionError((Object)("Selector for " + this.getTargetResource() + " received an empty host set"));
            }
            case 1: {
                Single<C> connection = this.selectFromHost(hosts.get(0), selector, forceNewConnectionAndReserve, context);
                return connection == null ? this.noActiveHosts(hosts) : connection;
            }
        }
        return this.p2c(size, hosts, this.getRandom(), selector, forceNewConnectionAndReserve, context);
    }

    private Single<C> p2c(int size, List<Host<ResolvedAddress, C>> hosts, Random random, Predicate<C> selector, boolean forceNewConnectionAndReserve, @Nullable ContextMap contextMap) {
        int j;
        int n = j = hosts.size() == 2 ? 1 : this.maxEffort;
        while (j > 0) {
            Single<C> result;
            int i1 = random.nextInt(size);
            int i2 = random.nextInt(size - 1);
            if (i2 >= i1) {
                ++i2;
            }
            Host<ResolvedAddress, C> t1 = hosts.get(i1);
            Host<ResolvedAddress, C> t2 = hosts.get(i2);
            if (t1.score() < t2.score()) {
                Host<ResolvedAddress, C> tmp = t1;
                t1 = t2;
                t2 = tmp;
            }
            if ((result = this.selectFromHost(t1, selector, forceNewConnectionAndReserve, contextMap)) != null) {
                return result;
            }
            result = this.selectFromHost(t2, selector, forceNewConnectionAndReserve, contextMap);
            if (result != null) {
                return result;
            }
            --j;
        }
        return this.noActiveHosts(hosts);
    }

    @Nullable
    private Single<C> selectFromHost(Host<ResolvedAddress, C> host, Predicate<C> selector, boolean forceNewConnectionAndReserve, @Nullable ContextMap contextMap) {
        C c;
        if (!forceNewConnectionAndReserve && (c = host.pickConnection(selector, contextMap)) != null) {
            return Single.succeeded(c);
        }
        if (host.isActiveAndHealthy()) {
            return host.newConnection(selector, forceNewConnectionAndReserve, contextMap);
        }
        return null;
    }

    private Random getRandom() {
        return this.random == null ? ThreadLocalRandom.current() : this.random;
    }
}

