/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.loadbalancer.Exceptions;
import io.servicetalk.loadbalancer.Host;
import io.servicetalk.loadbalancer.HostSelector;
import java.util.List;
import java.util.Objects;

abstract class BaseHostSelector<ResolvedAddress, C extends LoadBalancedConnection>
implements HostSelector<ResolvedAddress, C> {
    private final String targetResource;

    BaseHostSelector(String targetResource) {
        this.targetResource = Objects.requireNonNull(targetResource, "targetResource");
    }

    protected final String getTargetResource() {
        return this.targetResource;
    }

    protected final Single<C> noActiveHosts(List<Host<ResolvedAddress, C>> usedHosts) {
        return Single.failed(Exceptions.StacklessNoActiveHostException.newInstance("Failed to pick an active host for " + this.getTargetResource() + ". Either all are busy, expired, or unhealthy: " + usedHosts, this.getClass(), "selectConnection(...)"));
    }
}

