/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.client.api.LoadBalancerReadyEvent;
import io.servicetalk.client.api.NoAvailableHostException;
import io.servicetalk.concurrent.api.AsyncContext;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.RetryStrategies;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.http.api.FilterableReservedStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpClient;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpContextKeys;
import io.servicetalk.http.api.HttpExecutionStrategies;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpClientFilter;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.http.netty.ExpectationFailedException;
import io.servicetalk.transport.api.ExecutionContext;
import io.servicetalk.transport.api.ExecutionStrategyInfluencer;
import io.servicetalk.transport.api.RetryableException;
import io.servicetalk.utils.internal.DurationUtils;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

public final class RetryingHttpRequesterFilter
implements StreamingHttpClientFilterFactory,
ExecutionStrategyInfluencer<HttpExecutionStrategy> {
    static final int DEFAULT_MAX_TOTAL_RETRIES = 4;
    private static final RetryingHttpRequesterFilter DISABLE_AUTO_RETRIES = new RetryingHttpRequesterFilter(true, false, false, 1, null, (__, ___) -> BackOffPolicy.NO_RETRIES);
    private static final RetryingHttpRequesterFilter DISABLE_ALL_RETRIES = new RetryingHttpRequesterFilter(false, true, false, 0, null, (__, ___) -> BackOffPolicy.NO_RETRIES);
    private final boolean waitForLb;
    private final boolean ignoreSdErrors;
    private final boolean mayReplayRequestPayload;
    private final int maxTotalRetries;
    @Nullable
    private final Function<HttpResponseMetaData, HttpResponseException> responseMapper;
    private final BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> retryFor;

    RetryingHttpRequesterFilter(boolean waitForLb, boolean ignoreSdErrors, boolean mayReplayRequestPayload, int maxTotalRetries, @Nullable Function<HttpResponseMetaData, HttpResponseException> responseMapper, BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> retryFor) {
        this.waitForLb = waitForLb;
        this.ignoreSdErrors = ignoreSdErrors;
        this.mayReplayRequestPayload = mayReplayRequestPayload;
        this.maxTotalRetries = maxTotalRetries;
        this.responseMapper = responseMapper;
        this.retryFor = retryFor;
    }

    @Override
    public StreamingHttpClientFilter create(FilterableStreamingHttpClient client) {
        return new ContextAwareRetryingHttpClientFilter(client);
    }

    @Override
    public HttpExecutionStrategy requiredOffloads() {
        return HttpExecutionStrategies.offloadNone();
    }

    public static RetryingHttpRequesterFilter disableAutoRetries() {
        return DISABLE_AUTO_RETRIES;
    }

    public static RetryingHttpRequesterFilter disableAllRetries() {
        return DISABLE_ALL_RETRIES;
    }

    private static UnaryOperator<Publisher<?>> messageBodyDuplicator(Publisher<?> originalPublisher) {
        return p -> originalPublisher.map(item -> {
            if (item instanceof Buffer) {
                return ((Buffer)item).duplicate();
            }
            return item;
        });
    }

    public static final class Builder {
        private static final Function<HttpResponseMetaData, HttpResponseException> EXPECTATION_FAILED_MAPPER = metaData -> HttpResponseStatus.EXPECTATION_FAILED.equals(metaData.status()) ? new ExpectationFailedException("Expectation failed", (HttpResponseMetaData)metaData) : null;
        private boolean waitForLb = true;
        private boolean ignoreSdErrors;
        private int maxTotalRetries = 4;
        private boolean retryExpectationFailed;
        private BiFunction<HttpRequestMetaData, RetryableException, BackOffPolicy> retryRetryableExceptions = (requestMetaData, e) -> BackOffPolicy.ofImmediateBounded();
        @Nullable
        private Function<HttpResponseMetaData, HttpResponseException> responseMapper;
        @Nullable
        private BiFunction<HttpRequestMetaData, IOException, BackOffPolicy> retryIdempotentRequests;
        @Nullable
        private BiFunction<HttpRequestMetaData, DelayedRetry, BackOffPolicy> retryDelayedRetries;
        @Nullable
        private BiFunction<HttpRequestMetaData, HttpResponseException, BackOffPolicy> retryResponses;
        @Nullable
        private BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> retryOther;

        public Builder waitForLoadBalancer(boolean waitForLb) {
            this.waitForLb = waitForLb;
            return this;
        }

        public Builder ignoreServiceDiscovererErrors(boolean ignoreSdErrors) {
            this.ignoreSdErrors = ignoreSdErrors;
            return this;
        }

        public Builder maxTotalRetries(int maxRetries) {
            if (maxRetries <= 0) {
                throw new IllegalArgumentException("maxRetries: " + maxRetries + " (expected: >0)");
            }
            this.maxTotalRetries = maxRetries;
            return this;
        }

        public Builder responseMapper(Function<HttpResponseMetaData, HttpResponseException> mapper) {
            this.responseMapper = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryRetryableExceptions(BiFunction<HttpRequestMetaData, RetryableException, BackOffPolicy> mapper) {
            this.retryRetryableExceptions = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryIdempotentRequests(BiFunction<HttpRequestMetaData, IOException, BackOffPolicy> mapper) {
            this.retryIdempotentRequests = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryExpectationFailed(boolean retryExpectationFailed) {
            this.retryExpectationFailed = retryExpectationFailed;
            return this;
        }

        public Builder retryDelayedRetries(BiFunction<HttpRequestMetaData, DelayedRetry, BackOffPolicy> mapper) {
            this.retryDelayedRetries = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryResponses(BiFunction<HttpRequestMetaData, HttpResponseException, BackOffPolicy> mapper) {
            this.retryResponses = Objects.requireNonNull(mapper);
            return this;
        }

        public Builder retryOther(BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> mapper) {
            this.retryOther = Objects.requireNonNull(mapper);
            return this;
        }

        public RetryingHttpRequesterFilter build() {
            boolean retryExpectationFailed = this.retryExpectationFailed;
            Function<HttpResponseMetaData, HttpResponseException> thisResponseMapper = this.responseMapper;
            Function<HttpResponseMetaData, HttpResponseException> responseMapper = retryExpectationFailed ? (thisResponseMapper == null ? EXPECTATION_FAILED_MAPPER : metaData -> {
                HttpResponseException e = (HttpResponseException)thisResponseMapper.apply((HttpResponseMetaData)metaData);
                return e == null ? EXPECTATION_FAILED_MAPPER.apply((HttpResponseMetaData)metaData) : e;
            }) : thisResponseMapper;
            BiFunction<HttpRequestMetaData, RetryableException, BackOffPolicy> retryRetryableExceptions = this.retryRetryableExceptions;
            BiFunction<HttpRequestMetaData, IOException, BackOffPolicy> retryIdempotentRequests = this.retryIdempotentRequests;
            BiFunction<HttpRequestMetaData, DelayedRetry, BackOffPolicy> retryDelayedRetries = this.retryDelayedRetries;
            BiFunction<HttpRequestMetaData, HttpResponseException, BackOffPolicy> retryResponses = this.retryResponses;
            BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> retryOther = this.retryOther;
            boolean mayReplayRequestPayload = retryIdempotentRequests != null || retryDelayedRetries != null || retryResponses != null || retryOther != null;
            BiFunction<HttpRequestMetaData, Throwable, BackOffPolicy> allPredicate = (requestMetaData, throwable) -> {
                BackOffPolicy backOffPolicy;
                if (throwable instanceof RetryableException && (backOffPolicy = (BackOffPolicy)retryRetryableExceptions.apply((HttpRequestMetaData)requestMetaData, (RetryableException)((Object)throwable))) != BackOffPolicy.NO_RETRIES) {
                    return backOffPolicy;
                }
                if (retryExpectationFailed && throwable instanceof ExpectationFailedException && requestMetaData.headers().containsIgnoreCase(HttpHeaderNames.EXPECT, HttpHeaderValues.CONTINUE)) {
                    requestMetaData.headers().remove(HttpHeaderNames.EXPECT);
                    return BackOffPolicy.ofImmediateBounded();
                }
                if (retryIdempotentRequests != null && throwable instanceof IOException && requestMetaData.method().properties().isIdempotent() && (backOffPolicy = (BackOffPolicy)retryIdempotentRequests.apply((HttpRequestMetaData)requestMetaData, (IOException)throwable)) != BackOffPolicy.NO_RETRIES) {
                    return backOffPolicy;
                }
                if (retryDelayedRetries != null && throwable instanceof DelayedRetry && (backOffPolicy = (BackOffPolicy)retryDelayedRetries.apply((HttpRequestMetaData)requestMetaData, (DelayedRetry)((Object)throwable))) != BackOffPolicy.NO_RETRIES) {
                    return backOffPolicy;
                }
                if (retryResponses != null && throwable instanceof HttpResponseException && (backOffPolicy = (BackOffPolicy)retryResponses.apply((HttpRequestMetaData)requestMetaData, (HttpResponseException)throwable)) != BackOffPolicy.NO_RETRIES) {
                    return backOffPolicy;
                }
                if (retryOther != null) {
                    return (BackOffPolicy)retryOther.apply((HttpRequestMetaData)requestMetaData, (Throwable)throwable);
                }
                return BackOffPolicy.NO_RETRIES;
            };
            return new RetryingHttpRequesterFilter(this.waitForLb, this.ignoreSdErrors, mayReplayRequestPayload, this.maxTotalRetries, responseMapper, allPredicate);
        }
    }

    public static interface DelayedRetry {
        public Duration delay();
    }

    public static final class BackOffPolicy {
        private static final Duration FULL_JITTER = Duration.ofDays(1024L);
        private static final BackOffPolicy IMMEDIATE_DEFAULT_RETRIES = new BackOffPolicy(3);
        @Deprecated
        public static final BackOffPolicy NO_RETRIES = new BackOffPolicy(0);
        @Nullable
        final Duration initialDelay;
        @Nullable
        final Duration jitter;
        @Nullable
        final Duration maxDelay;
        @Nullable
        final Executor timerExecutor;
        final boolean exponential;
        final int maxRetries;

        BackOffPolicy(Duration initialDelay, Duration jitter, @Nullable Duration maxDelay, @Nullable Executor timerExecutor, boolean exponential, int maxRetries) {
            this.initialDelay = DurationUtils.ensurePositive(initialDelay, "Initial delay should be a positive value.");
            this.jitter = DurationUtils.ensurePositive(jitter, "jitter should be a positive value.");
            this.maxDelay = maxDelay != null ? DurationUtils.ensurePositive(maxDelay, "Max delay (if provided), should be a positive value.") : null;
            this.timerExecutor = timerExecutor;
            this.exponential = exponential;
            if (maxRetries <= 0) {
                throw new IllegalArgumentException("maxRetries: " + maxRetries + " (expected > 0).");
            }
            this.maxRetries = maxRetries;
        }

        BackOffPolicy(int maxRetries) {
            this.initialDelay = null;
            this.jitter = null;
            this.maxDelay = null;
            this.timerExecutor = null;
            this.exponential = false;
            if (maxRetries < 0) {
                throw new IllegalArgumentException("maxRetries: " + maxRetries + " (expected >= 0).");
            }
            this.maxRetries = maxRetries;
        }

        @Deprecated
        public static BackOffPolicy ofImmediate() {
            return BackOffPolicy.ofImmediateBounded();
        }

        public static BackOffPolicy ofImmediateBounded() {
            return IMMEDIATE_DEFAULT_RETRIES;
        }

        public static BackOffPolicy ofImmediate(int maxRetries) {
            return new BackOffPolicy(maxRetries);
        }

        public static BackOffPolicy ofNoRetries() {
            return NO_RETRIES;
        }

        public static BackOffPolicy ofConstantBackoffFullJitter(Duration delay, int maxRetries) {
            return new BackOffPolicy(delay, FULL_JITTER, null, null, false, maxRetries);
        }

        public static BackOffPolicy ofConstantBackoffFullJitter(Duration delay, int maxRetries, Executor timerExecutor) {
            return new BackOffPolicy(delay, FULL_JITTER, null, timerExecutor, false, maxRetries);
        }

        public static BackOffPolicy ofConstantBackoffDeltaJitter(Duration delay, Duration jitter, int maxRetries) {
            return new BackOffPolicy(delay, jitter, null, null, false, maxRetries);
        }

        public static BackOffPolicy ofConstantBackoffDeltaJitter(Duration delay, Duration jitter, Executor timerExecutor, int maxRetries) {
            return new BackOffPolicy(delay, jitter, null, timerExecutor, false, maxRetries);
        }

        public static BackOffPolicy ofExponentialBackoffFullJitter(Duration initialDelay, Duration maxDelay, int maxRetries) {
            return new BackOffPolicy(initialDelay, FULL_JITTER, maxDelay, null, true, maxRetries);
        }

        public static BackOffPolicy ofExponentialBackoffFullJitter(Duration initialDelay, Duration maxDelay, int maxRetries, Executor timerExecutor) {
            return new BackOffPolicy(initialDelay, FULL_JITTER, maxDelay, timerExecutor, true, maxRetries);
        }

        public static BackOffPolicy ofExponentialBackoffDeltaJitter(Duration initialDelay, Duration jitter, Duration maxDelay, int maxRetries) {
            return new BackOffPolicy(initialDelay, jitter, maxDelay, null, true, maxRetries);
        }

        public static BackOffPolicy ofExponentialBackoffDeltaJitter(Duration initialDelay, Duration jitter, Duration maxDelay, int maxRetries, Executor timerExecutor) {
            return new BackOffPolicy(initialDelay, jitter, maxDelay, timerExecutor, true, maxRetries);
        }

        public BiIntFunction<Throwable, Completable> newStrategy(Executor alternativeTimerExecutor) {
            Executor effectiveExecutor;
            if (this.initialDelay == null) {
                return (count, throwable) -> count <= this.maxRetries ? Completable.completed() : Completable.failed(throwable);
            }
            assert (this.jitter != null);
            Executor executor = effectiveExecutor = this.timerExecutor == null ? Objects.requireNonNull(alternativeTimerExecutor) : this.timerExecutor;
            if (this.exponential) {
                assert (this.maxDelay != null);
                return this.jitter == FULL_JITTER ? RetryStrategies.retryWithExponentialBackoffFullJitter(this.maxRetries, t -> true, this.initialDelay, this.maxDelay, effectiveExecutor) : RetryStrategies.retryWithExponentialBackoffDeltaJitter(this.maxRetries, t -> true, this.initialDelay, this.jitter, this.maxDelay, effectiveExecutor);
            }
            return this.jitter == FULL_JITTER ? RetryStrategies.retryWithConstantBackoffFullJitter(this.maxRetries, t -> true, this.initialDelay, effectiveExecutor) : RetryStrategies.retryWithConstantBackoffDeltaJitter(this.maxRetries, t -> true, this.initialDelay, this.jitter, effectiveExecutor);
        }
    }

    public static class HttpResponseException
    extends RuntimeException {
        private static final long serialVersionUID = -7182949760823647710L;
        @Deprecated
        public final HttpResponseMetaData metaData;
        @Deprecated
        public final String message;

        public HttpResponseException(String message, HttpResponseMetaData metaData) {
            super(message);
            this.metaData = Objects.requireNonNull(metaData);
            this.message = Objects.requireNonNull(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        public HttpResponseMetaData metaData() {
            return this.metaData;
        }

        @Override
        public String toString() {
            return super.toString() + ", metaData=" + this.metaData.toString(HeaderUtils.DEFAULT_HEADER_FILTER);
        }
    }

    final class ContextAwareRetryingHttpClientFilter
    extends StreamingHttpClientFilter {
        @Nullable
        private Completable sdStatus;
        @Nullable
        private Publisher<Object> lbEventStream;

        private ContextAwareRetryingHttpClientFilter(FilterableStreamingHttpClient delegate) {
            super(delegate);
        }

        void inject(@Nullable Publisher<Object> lbEventStream, @Nullable Completable sdStatus) {
            this.sdStatus = RetryingHttpRequesterFilter.this.ignoreSdErrors ? null : Objects.requireNonNull(sdStatus);
            this.lbEventStream = RetryingHttpRequesterFilter.this.waitForLb ? Objects.requireNonNull(lbEventStream) : null;
        }

        BiIntFunction<Throwable, Completable> retryStrategy(HttpRequestMetaData requestMetaData, ExecutionContext<HttpExecutionStrategy> context) {
            HttpExecutionStrategy strategy = requestMetaData.context().getOrDefault(HttpContextKeys.HTTP_EXECUTION_STRATEGY_KEY, context.executionStrategy());
            assert (strategy != null);
            return new OuterRetryStrategy(strategy.isRequestResponseOffloaded() ? context.executor() : context.ioExecutor(), requestMetaData);
        }

        @Override
        public Single<? extends FilterableReservedStreamingHttpConnection> reserveConnection(HttpRequestMetaData metaData) {
            return this.delegate().reserveConnection(metaData).retryWhen(this.retryStrategy(metaData, this.executionContext()));
        }

        @Override
        protected Single<StreamingHttpResponse> request(StreamingHttpRequester delegate, StreamingHttpRequest request) {
            Publisher<Object> originalMessageBody = request.messageBody();
            AtomicReference contextRef = new AtomicReference();
            Single<StreamingHttpResponse> single = Single.defer(() -> {
                Single<StreamingHttpResponse> reqSingle = delegate.request(request.transformMessageBody(RetryingHttpRequesterFilter.this.mayReplayRequestPayload ? RetryingHttpRequesterFilter.messageBodyDuplicator(originalMessageBody) : p -> originalMessageBody));
                ContextMap map = (ContextMap)contextRef.get();
                return map == null && contextRef.compareAndSet(null, AsyncContext.context()) ? reqSingle.shareContextOnSubscribe() : reqSingle.setContextOnSubscribe((ContextMap)contextRef.get());
            });
            if (RetryingHttpRequesterFilter.this.responseMapper != null) {
                single = single.flatMap(resp -> {
                    HttpResponseException exception = (HttpResponseException)RetryingHttpRequesterFilter.this.responseMapper.apply(resp);
                    return (exception != null ? resp.payloadBody().ignoreElements().onErrorComplete().concat(Single.failed(exception)) : Single.succeeded(resp)).shareContextOnSubscribe();
                });
            }
            return single.retryWhen(this.retryStrategy(request, this.executionContext()));
        }

        private final class OuterRetryStrategy
        implements BiIntFunction<Throwable, Completable> {
            private final Executor executor;
            private final HttpRequestMetaData requestMetaData;
            private int lbNotReadyCount;

            private OuterRetryStrategy(Executor executor, HttpRequestMetaData requestMetaData) {
                this.executor = executor;
                this.requestMetaData = requestMetaData;
            }

            @Override
            public Completable apply(int count, Throwable t) {
                if (count > RetryingHttpRequesterFilter.this.maxTotalRetries) {
                    return Completable.failed(t);
                }
                if (ContextAwareRetryingHttpClientFilter.this.lbEventStream != null && t instanceof NoAvailableHostException) {
                    ++this.lbNotReadyCount;
                    Completable onHostsAvailable = ContextAwareRetryingHttpClientFilter.this.lbEventStream.onCompleteError(() -> new IllegalStateException("Subscriber listening for " + LoadBalancerReadyEvent.class.getSimpleName() + " completed unexpectedly")).takeWhile(lbEvent -> !(lbEvent instanceof LoadBalancerReadyEvent) || !((LoadBalancerReadyEvent)lbEvent).isReady()).ignoreElements();
                    return ContextAwareRetryingHttpClientFilter.this.sdStatus == null ? onHostsAvailable : onHostsAvailable.ambWith(ContextAwareRetryingHttpClientFilter.this.sdStatus);
                }
                BackOffPolicy backOffPolicy = (BackOffPolicy)RetryingHttpRequesterFilter.this.retryFor.apply(this.requestMetaData, t);
                if (backOffPolicy != BackOffPolicy.NO_RETRIES) {
                    int offsetCount = count - this.lbNotReadyCount;
                    if (t instanceof DelayedRetry) {
                        Duration constant = ((DelayedRetry)((Object)t)).delay();
                        return backOffPolicy.newStrategy(this.executor).apply(offsetCount, t).concat(this.executor.timer(constant));
                    }
                    return backOffPolicy.newStrategy(this.executor).apply(offsetCount, t);
                }
                return Completable.failed(t);
            }
        }
    }
}

