/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMetaDataFactory;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.ProxyConfig;
import io.servicetalk.http.api.ProxyConnectException;
import io.servicetalk.http.api.ProxyConnectResponseException;
import io.servicetalk.http.netty.ChannelInitSingle;
import io.servicetalk.http.netty.ProxyResponseException;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.RetryableException;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.ChannelInitializer;
import io.servicetalk.transport.netty.internal.CloseHandler;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProxyConnectChannelSingle
extends ChannelInitSingle<Channel> {
    private final ConnectionObserver observer;
    private final HttpHeadersFactory headersFactory;
    private final ProxyConfig<String> proxyConfig;

    ProxyConnectChannelSingle(Channel channel, ChannelInitializer channelInitializer, ConnectionObserver observer, HttpHeadersFactory headersFactory, ProxyConfig<String> proxyConfig) {
        super(channel, channelInitializer);
        this.observer = observer;
        this.headersFactory = headersFactory;
        this.proxyConfig = proxyConfig;
        assert (!channel.config().isAutoRead());
    }

    @Override
    protected ChannelHandler newChannelHandler(SingleSource.Subscriber<? super Channel> subscriber) {
        return new ProxyConnectHandler(this.observer, this.headersFactory, this.proxyConfig, subscriber);
    }

    private static final class RetryableProxyConnectResponseException
    extends ProxyResponseException
    implements RetryableException {
        private static final long serialVersionUID = -4572727779387205399L;

        RetryableProxyConnectResponseException(String message, HttpResponseMetaData response) {
            super(message, response);
        }
    }

    static final class RetryableProxyConnectException
    extends ProxyConnectException
    implements RetryableException {
        private static final long serialVersionUID = 5118637083568536242L;

        RetryableProxyConnectException(String message) {
            super(message);
        }

        RetryableProxyConnectException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static final class ProxyConnectHandler
    extends ChannelDuplexHandler {
        private static final Logger LOGGER = LoggerFactory.getLogger(ProxyConnectHandler.class);
        private final ConnectionObserver observer;
        private final HttpHeadersFactory headersFactory;
        private final ProxyConfig<String> proxyConfig;
        @Nullable
        private SingleSource.Subscriber<? super Channel> subscriber;
        @Nullable
        private ConnectionObserver.ProxyConnectObserver connectObserver;
        @Nullable
        private HttpResponseMetaData response;

        private ProxyConnectHandler(ConnectionObserver observer, HttpHeadersFactory headersFactory, ProxyConfig<String> proxyConfig, SingleSource.Subscriber<? super Channel> subscriber) {
            this.observer = observer;
            this.headersFactory = headersFactory;
            this.proxyConfig = proxyConfig;
            this.subscriber = subscriber;
        }

        @Override
        public void handlerAdded(ChannelHandlerContext ctx) {
            if (ctx.channel().isActive()) {
                this.sendConnectRequest(ctx);
            }
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            this.sendConnectRequest(ctx);
            ctx.fireChannelActive();
        }

        private void sendConnectRequest(ChannelHandlerContext ctx) {
            HttpRequestMetaData request = HttpRequestMetaDataFactory.newRequestMetaData(HttpProtocolVersion.HTTP_1_1, HttpRequestMethod.CONNECT, this.proxyConfig.address(), this.headersFactory.newHeaders()).addHeader(HttpHeaderNames.HOST, this.proxyConfig.address());
            this.proxyConfig.connectRequestHeadersInitializer().accept(request.headers());
            this.connectObserver = this.observer.onProxyConnect(request);
            ctx.writeAndFlush(request).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                if (f.isSuccess()) {
                    ctx.read();
                } else {
                    this.failSubscriber(ctx, new RetryableProxyConnectException(ctx.channel() + " Failed to write CONNECT request", f.cause()));
                }
            }));
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof HttpResponseMetaData) {
                if (this.response != null) {
                    this.failSubscriber(ctx, new RetryableProxyConnectException(ctx.channel() + " Received two responses for a single CONNECT request"));
                    return;
                }
                this.response = (HttpResponseMetaData)msg;
                if (this.response.status().statusClass() != HttpResponseStatus.StatusClass.SUCCESSFUL_2XX) {
                    this.failSubscriber(ctx, ProxyConnectHandler.unsuccessfulResponse(ctx.channel(), this.response, this.proxyConfig.address()));
                }
            } else {
                this.failSubscriber(ctx, new RetryableProxyConnectException(ctx.channel() + " Received unexpected message in the pipeline of type: " + msg.getClass().getName()));
            }
        }

        private static ProxyConnectResponseException unsuccessfulResponse(Channel channel, HttpResponseMetaData response, String connectAddress) {
            String message = channel + " Non-successful response '" + response.status() + "' from proxy on CONNECT " + connectAddress;
            return ProxyConnectHandler.isRetryable(response.status()) ? new RetryableProxyConnectResponseException(message, response) : new ProxyConnectResponseException(message, response);
        }

        private static boolean isRetryable(HttpResponseStatus status) {
            return HttpResponseStatus.INTERNAL_SERVER_ERROR.equals(status) || HttpResponseStatus.BAD_GATEWAY.equals(status) || HttpResponseStatus.SERVICE_UNAVAILABLE.equals(status) || HttpResponseStatus.GATEWAY_TIMEOUT.equals(status) || HttpResponseStatus.TOO_MANY_REQUESTS.equals(status);
        }

        @Override
        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (this.subscriber != null) {
                ctx.read();
            }
            ctx.fireChannelReadComplete();
        }

        @Override
        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt != CloseHandler.InboundDataEndEvent.INSTANCE || this.subscriber == null) {
                ctx.fireUserEventTriggered(evt);
                return;
            }
            assert (this.response != null);
            assert (this.connectObserver != null);
            this.connectObserver.proxyConnectComplete(this.response);
            ctx.pipeline().remove(this);
            Channel channel = ctx.channel();
            LOGGER.debug("{} Received successful response from proxy on CONNECT {}", (Object)channel, (Object)this.proxyConfig.address());
            SingleSource.Subscriber<? super Channel> subscriberCopy = this.subscriber;
            this.subscriber = null;
            subscriberCopy.onSuccess(channel);
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            if (this.subscriber != null) {
                this.failSubscriber(ctx, new RetryableProxyConnectException(ctx.channel() + " Connection closed before proxy CONNECT finished"));
                return;
            }
            ctx.fireChannelInactive();
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.subscriber != null) {
                this.failSubscriber(ctx, new ProxyConnectException(ctx.channel() + " Unexpected exception before proxy CONNECT finished", cause));
                return;
            }
            ctx.fireExceptionCaught(cause);
        }

        private void failSubscriber(ChannelHandlerContext ctx, Throwable cause) {
            ChannelCloseUtils.assignConnectionError(ctx.channel(), cause);
            if (this.subscriber != null) {
                if (this.connectObserver != null) {
                    this.connectObserver.proxyConnectFailed(cause);
                }
                SingleSource.Subscriber<? super Channel> subscriberCopy = this.subscriber;
                this.subscriber = null;
                subscriberCopy.onError(cause);
            }
            ctx.close();
        }
    }
}

