/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.AbstractLBHttpConnectionFactory;
import io.servicetalk.http.netty.PipelinedStreamingHttpConnection;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.http.netty.StreamingConnectionFactory;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.NettyConnection;
import java.util.Objects;
import javax.annotation.Nullable;

final class PipelinedLBHttpConnectionFactory<ResolvedAddress>
extends AbstractLBHttpConnectionFactory<ResolvedAddress> {
    PipelinedLBHttpConnectionFactory(ReadOnlyHttpClientConfig config, HttpExecutionContext executionContext, @Nullable StreamingHttpConnectionFilterFactory connectionFilterFunction, StreamingHttpRequestResponseFactory reqRespFactory, ExecutionStrategy connectStrategy, ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> connectionFactoryFilter, AbstractLBHttpConnectionFactory.ProtocolBinding protocolBinding) {
        super(config, executionContext, (HttpProtocolVersion version) -> reqRespFactory, connectStrategy, connectionFactoryFilter, connectionFilterFunction, protocolBinding);
        Objects.requireNonNull(config.h1Config(), "H1ProtocolConfig is required");
    }

    @Override
    Single<FilterableStreamingHttpConnection> newFilterableConnection(ResolvedAddress resolvedAddress, TransportObserver observer) {
        assert (this.config.h1Config() != null);
        return StreamingConnectionFactory.buildStreaming(this.executionContext, resolvedAddress, this.config, observer).map(conn -> new PipelinedStreamingHttpConnection((NettyConnection<Object, Object>)conn, this.config.h1Config(), (StreamingHttpRequestResponseFactory)this.reqRespFactoryFunc.apply(HttpProtocolVersion.HTTP_1_1), this.config.allowDropTrailersReadFromTransport()));
    }
}

