/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.UniformStreamByteDistributor;
import io.servicetalk.utils.internal.ThrowableUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OptimizedHttp2FrameCodecBuilder
extends Http2FrameCodecBuilder {
    private static final Logger LOGGER;
    private static final String MAX_CONSECUTIVE_EMPTY_FRAMES_PROPERTY_NAME = "io.servicetalk.http.netty.http2.decoderEnforceMaxRstFramesPerWindow.maxConsecutiveEmptyFrames";
    private static final String MAX_RST_FRAMES_PER_WINDOW_PROPERTY_NAME = "io.servicetalk.http.netty.http2.decoderEnforceMaxRstFramesPerWindow.maxRstFramesPerWindow";
    private static final String SECONDS_PER_WINDOW_PROPERTY_NAME = "io.servicetalk.http.netty.http2.decoderEnforceMaxRstFramesPerWindow.secondsPerWindow";
    private static final int MAX_RST_FRAMES_PER_WINDOW;
    private static final int SECONDS_PER_WINDOW;
    @Nullable
    private static final MethodHandle FLUSH_PREFACE;
    @Nullable
    private static final MethodHandle DECODER_ENFORCE_MAX_RST_FRAMES_PER_WINDOW;
    private final boolean server;
    private final int flowControlQuantum;

    OptimizedHttp2FrameCodecBuilder(boolean server, int flowControlQuantum) {
        this.server = server;
        this.flowControlQuantum = flowControlQuantum;
        OptimizedHttp2FrameCodecBuilder.disableFlushPreface(FLUSH_PREFACE, this);
        OptimizedHttp2FrameCodecBuilder.decoderEnforceMaxRstFramesPerWindow(DECODER_ENFORCE_MAX_RST_FRAMES_PER_WINDOW, this, server);
    }

    @Override
    public boolean isServer() {
        return this.server;
    }

    @Override
    public Http2FrameCodec build() {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(this.isServer(), this.maxReservedStreams());
        UniformStreamByteDistributor distributor = new UniformStreamByteDistributor(connection);
        distributor.minAllocationChunk(this.flowControlQuantum);
        connection.remote().flowController(new DefaultHttp2RemoteFlowController((Http2Connection)connection, distributor));
        this.connection(connection);
        return super.build();
    }

    private static Http2FrameCodecBuilder disableFlushPreface(@Nullable MethodHandle flushPrefaceMethod, Http2FrameCodecBuilder builderInstance) {
        if (flushPrefaceMethod == null) {
            return builderInstance;
        }
        try {
            return flushPrefaceMethod.invokeExact(builderInstance, false);
        }
        catch (Throwable t) {
            ThrowableUtils.throwException(t);
            return builderInstance;
        }
    }

    private static Http2FrameCodecBuilder decoderEnforceMaxRstFramesPerWindow(@Nullable MethodHandle methodHandle, Http2FrameCodecBuilder builderInstance, boolean isServer) {
        int secondsPerWindow;
        int maxRstFramesPerWindow;
        if (methodHandle == null) {
            return builderInstance;
        }
        if (isServer) {
            maxRstFramesPerWindow = MAX_RST_FRAMES_PER_WINDOW;
            secondsPerWindow = SECONDS_PER_WINDOW;
        } else {
            maxRstFramesPerWindow = 0;
            secondsPerWindow = 0;
        }
        try {
            return methodHandle.invokeExact(builderInstance, maxRstFramesPerWindow, secondsPerWindow);
        }
        catch (Throwable t) {
            ThrowableUtils.throwException(t);
            return builderInstance;
        }
    }

    private static int parseProperty(String name, int defaultValue) {
        int intValue;
        String value = System.getProperty(name);
        if (value == null || value.isEmpty()) {
            intValue = defaultValue;
        } else {
            try {
                intValue = Integer.parseInt(value);
                if (intValue < 0) {
                    LOGGER.error("Found invalid value -D{}={} (expected >= 0), using fallback value={}", name, value, defaultValue);
                    return defaultValue;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.error("Could not parse -D{}={} (expected int >= 0), using fallback value={}", name, value, defaultValue, e);
                return defaultValue;
            }
        }
        LOGGER.debug("-D{}={}", (Object)name, (Object)intValue);
        return intValue;
    }

    static {
        MethodHandle decoderEnforceMaxRstFramesPerWindow;
        MethodHandle flushPreface;
        LOGGER = LoggerFactory.getLogger(OptimizedHttp2FrameCodecBuilder.class);
        MAX_RST_FRAMES_PER_WINDOW = OptimizedHttp2FrameCodecBuilder.parseProperty(MAX_RST_FRAMES_PER_WINDOW_PROPERTY_NAME, OptimizedHttp2FrameCodecBuilder.parseProperty(MAX_CONSECUTIVE_EMPTY_FRAMES_PROPERTY_NAME, 200));
        SECONDS_PER_WINDOW = OptimizedHttp2FrameCodecBuilder.parseProperty(SECONDS_PER_WINDOW_PROPERTY_NAME, 30);
        Http2FrameCodecBuilder builder = Http2FrameCodecBuilder.forServer();
        try {
            flushPreface = MethodHandles.publicLookup().findVirtual(Http2FrameCodecBuilder.class, "flushPreface", MethodType.methodType(Http2FrameCodecBuilder.class, Boolean.TYPE));
            OptimizedHttp2FrameCodecBuilder.disableFlushPreface(flushPreface, builder);
        }
        catch (Throwable cause) {
            LOGGER.debug("Http2FrameCodecBuilder#flushPreface(boolean) is available only starting from Netty 4.1.78.Final. Detected Netty version: {}", (Object)Http2FrameCodecBuilder.class.getPackage().getImplementationVersion(), (Object)cause);
            flushPreface = null;
        }
        FLUSH_PREFACE = flushPreface;
        try {
            decoderEnforceMaxRstFramesPerWindow = MethodHandles.publicLookup().findVirtual(Http2FrameCodecBuilder.class, "decoderEnforceMaxRstFramesPerWindow", MethodType.methodType(Http2FrameCodecBuilder.class, Integer.TYPE, Integer.TYPE));
            OptimizedHttp2FrameCodecBuilder.decoderEnforceMaxRstFramesPerWindow(decoderEnforceMaxRstFramesPerWindow, builder, builder.isServer());
        }
        catch (Throwable cause) {
            LOGGER.debug("Http2FrameCodecBuilder#decoderEnforceMaxRstFramesPerWindow(int, int) is available only starting from Netty 4.1.100.Final. Detected Netty version: {}", (Object)Http2FrameCodecBuilder.class.getPackage().getImplementationVersion(), (Object)cause);
            decoderEnforceMaxRstFramesPerWindow = null;
        }
        DECODER_ENFORCE_MAX_RST_FRAMES_PER_WINDOW = decoderEnforceMaxRstFramesPerWindow;
    }
}

