/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.servicetalk.http.api.Http2ErrorCode;
import io.servicetalk.http.api.Http2Exception;
import io.servicetalk.transport.api.RetryableException;

final class NettyHttp2ExceptionUtils {
    private NettyHttp2ExceptionUtils() {
    }

    static Throwable wrapIfNecessary(Throwable cause) {
        if (cause instanceof io.netty.handler.codec.http2.Http2Exception) {
            int streamId = cause instanceof Http2Exception.StreamException ? ((Http2Exception.StreamException)cause).streamId() : 0;
            io.netty.handler.codec.http2.Http2Exception h2Cause = (io.netty.handler.codec.http2.Http2Exception)cause;
            if (h2Cause.error() == Http2Error.REFUSED_STREAM) {
                if (cause.getMessage() != null && cause.getMessage().startsWith("Maximum active streams violated for this endpoint")) {
                    return new MaxConcurrentStreamsViolatedStacklessHttp2Exception(streamId, h2Cause);
                }
            } else if (h2Cause instanceof Http2NoMoreStreamIdsException) {
                return new RetryableStacklessHttp2Exception(streamId, h2Cause);
            }
            return new StacklessHttp2Exception(streamId, h2Cause);
        }
        if (cause instanceof Http2FrameStreamException) {
            Http2FrameStreamException streamException = (Http2FrameStreamException)cause;
            return NettyHttp2ExceptionUtils.isRetryable(streamException) ? new RetryableStacklessHttp2Exception(streamException.stream().id(), streamException) : new StacklessHttp2Exception(streamException.stream().id(), streamException);
        }
        return cause;
    }

    static H2StreamResetException newStreamResetException(Http2ResetFrame resetFrame) {
        Http2FrameStream stream = resetFrame.stream();
        assert (stream != null);
        return resetFrame.errorCode() == Http2Error.REFUSED_STREAM.code() ? new H2StreamRefusedException(stream.id()) : new H2StreamResetException(stream.id(), (int)resetFrame.errorCode());
    }

    private static boolean isRetryable(Http2FrameStreamException cause) {
        return cause.error() == Http2Error.REFUSED_STREAM;
    }

    private static Http2ErrorCode nettyToStErrorCode(Http2Error error) {
        return NettyHttp2ExceptionUtils.stErrorCode((int)error.code());
    }

    private static Http2ErrorCode stErrorCode(int code) {
        Http2ErrorCode errorCode = Http2ErrorCode.of(code);
        return errorCode == null ? Http2ErrorCode.of(code, String.valueOf(code)) : errorCode;
    }

    private static final class H2StreamRefusedException
    extends H2StreamResetException
    implements RetryableException {
        private static final long serialVersionUID = -2151927266051609262L;

        H2StreamRefusedException(int streamId) {
            super(streamId, Http2ErrorCode.REFUSED_STREAM);
        }
    }

    static final class MaxConcurrentStreamsViolatedStacklessHttp2Exception
    extends RetryableStacklessHttp2Exception {
        private static final long serialVersionUID = 5519486857188675226L;

        MaxConcurrentStreamsViolatedStacklessHttp2Exception(int streamId, io.netty.handler.codec.http2.Http2Exception cause) {
            super(streamId, cause);
        }
    }

    private static class RetryableStacklessHttp2Exception
    extends Http2Exception
    implements RetryableException {
        private static final long serialVersionUID = -413341269442893267L;

        RetryableStacklessHttp2Exception(int streamId, io.netty.handler.codec.http2.Http2Exception cause) {
            super(streamId, NettyHttp2ExceptionUtils.nettyToStErrorCode(cause.error()), cause);
        }

        RetryableStacklessHttp2Exception(int streamId, Http2FrameStreamException cause) {
            super(streamId, NettyHttp2ExceptionUtils.nettyToStErrorCode(cause.error()), cause);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    private static final class StacklessHttp2Exception
    extends Http2Exception {
        private static final long serialVersionUID = 7120356856138442469L;

        StacklessHttp2Exception(int streamId, io.netty.handler.codec.http2.Http2Exception cause) {
            super(streamId, NettyHttp2ExceptionUtils.nettyToStErrorCode(cause.error()), cause);
        }

        StacklessHttp2Exception(int streamId, Http2FrameStreamException cause) {
            super(streamId, NettyHttp2ExceptionUtils.nettyToStErrorCode(cause.error()), cause);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static class H2StreamResetException
    extends Http2Exception {
        private static final long serialVersionUID = -7096164907438998924L;

        H2StreamResetException(int streamId, int errorCode) {
            this(streamId, NettyHttp2ExceptionUtils.stErrorCode(errorCode));
        }

        H2StreamResetException(int streamId, Http2ErrorCode errorCode) {
            super(streamId, errorCode, "RST_STREAM received for streamId=" + streamId + " with error code: " + errorCode);
        }
    }
}

