/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.util.ByteProcessor;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseMetaData;
import io.servicetalk.http.api.HttpResponseMetaDataFactory;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.netty.HttpObjectDecoder;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.DefaultNettyConnection;
import io.servicetalk.utils.internal.IllegalCharacterException;
import java.nio.charset.StandardCharsets;
import java.util.Deque;
import java.util.Objects;
import java.util.Queue;

final class HttpResponseDecoder
extends HttpObjectDecoder<HttpResponseMetaData> {
    private static final byte[] FIRST_BYTES = "HTTP/".getBytes(StandardCharsets.US_ASCII);
    private static final byte DEL = 127;
    private static final ByteProcessor ENSURE_REASON_PHRASE = value -> {
        if ((value & 0xE0) == 0 && value != 9 || value == 127) {
            throw new IllegalCharacterException(value, "HTAB / SP / VCHAR / obs-text");
        }
        return true;
    };
    private final Queue<HttpRequestMethod> methodQueue;
    private final Deque<Signal> signalsQueue;

    HttpResponseDecoder(Queue<HttpRequestMethod> methodQueue, Deque<Signal> signalsQueue, ByteBufAllocator alloc, HttpHeadersFactory headersFactory, int maxStartLineLength, int maxHeaderFieldLength, boolean allowPrematureClosureBeforePayloadBody, boolean allowLFWithoutCR, CloseHandler closeHandler) {
        super(alloc, headersFactory, maxStartLineLength, maxHeaderFieldLength, allowPrematureClosureBeforePayloadBody, allowLFWithoutCR, closeHandler);
        this.methodQueue = Objects.requireNonNull(methodQueue);
        this.signalsQueue = Objects.requireNonNull(signalsQueue);
    }

    @Override
    protected boolean isDecodingRequest() {
        return false;
    }

    @Override
    protected void handlePartialInitialLine(ChannelHandlerContext ctx, ByteBuf buffer) {
        int len = Math.min(FIRST_BYTES.length, buffer.readableBytes());
        int rIdx = buffer.readerIndex();
        for (int i = 0; i < len; ++i) {
            byte b = buffer.getByte(rIdx + i);
            if (b == FIRST_BYTES[i]) continue;
            throw new HttpObjectDecoder.StacklessDecoderException("Invalid start-line: HTTP response must start with HTTP-version: HTTP/1.x", new IllegalCharacterException(b));
        }
    }

    @Override
    protected HttpResponseMetaData createMessage(ByteBuf buffer, int firstStart, int firstLength, int secondStart, int secondLength, int thirdStart, int thirdLength) {
        return HttpResponseMetaDataFactory.newResponseMetaData(HttpResponseDecoder.nettyBufferToHttpVersion(buffer, firstStart, firstLength), HttpResponseStatus.of(HttpResponseDecoder.nettyBufferToStatusCode(buffer, secondStart, secondLength), HttpResponseDecoder.reasonPhrase(buffer, thirdStart, thirdLength)), this.headersFactory().newHeaders());
    }

    private static String reasonPhrase(ByteBuf buffer, int start, int length) {
        if (length <= 0) {
            return "";
        }
        String reasonPhrase = buffer.toString(start, length, StandardCharsets.US_ASCII);
        try {
            buffer.forEachByte(start, length, ENSURE_REASON_PHRASE);
        }
        catch (IllegalCharacterException cause) {
            throw new HttpObjectDecoder.StacklessDecoderException("Invalid start-line: HTTP reason-phrase contains an illegal character", cause);
        }
        return reasonPhrase;
    }

    @Override
    protected boolean isContentAlwaysEmpty(HttpResponseMetaData msg) {
        if (msg.status().statusClass() == HttpResponseStatus.StatusClass.INFORMATIONAL_1XX) {
            return msg.status().code() != HttpResponseStatus.SWITCHING_PROTOCOLS.code() || msg.headers().contains(HttpHeaderNames.SEC_WEBSOCKET_ACCEPT) || !msg.headers().containsIgnoreCase(HttpHeaderNames.UPGRADE, HttpHeaderValues.WEBSOCKET);
        }
        HttpRequestMethod method = this.methodQueue.poll();
        if (HttpRequestMethod.CONNECT.equals(method) && msg.status().statusClass() == HttpResponseStatus.StatusClass.SUCCESSFUL_2XX) {
            return true;
        }
        return HttpRequestMethod.HEAD.equals(method) || msg.status().code() == HttpResponseStatus.NO_CONTENT.code() || msg.status().code() == HttpResponseStatus.NOT_MODIFIED.code();
    }

    @Override
    protected boolean isInterim(HttpResponseMetaData msg) {
        return msg.status().statusClass() == HttpResponseStatus.StatusClass.INFORMATIONAL_1XX;
    }

    @Override
    protected void onMetaDataRead(ChannelHandlerContext ctx, HttpResponseMetaData msg) {
        Signal signal = this.signalsQueue.poll();
        assert (signal != null);
        if (signal != Signal.REQUEST_WITH_EXPECT_CONTINUE_SIGNAL) {
            return;
        }
        HttpResponseStatus status = msg.status();
        if (status.code() == HttpResponseStatus.CONTINUE.code()) {
            ctx.fireUserEventTriggered(DefaultNettyConnection.ContinueUserEvent.INSTANCE);
            this.signalsQueue.offerLast(Signal.REQUEST_SIGNAL);
        } else if (status.statusClass() == HttpResponseStatus.StatusClass.SUCCESSFUL_2XX) {
            ctx.fireUserEventTriggered(DefaultNettyConnection.ContinueUserEvent.INSTANCE);
        } else if (!this.isInterim(msg)) {
            ctx.fireUserEventTriggered(DefaultNettyConnection.CancelWriteUserEvent.INSTANCE);
        }
    }

    @Override
    protected void onDataSeen() {
    }

    private static int nettyBufferToStatusCode(ByteBuf buffer, int start, int length) {
        HttpResponseDecoder.ensureStatusCodeLength(length);
        int medium = buffer.getUnsignedMedium(start);
        try {
            return HttpResponseDecoder.toDecimal((medium & 0xFF0000) >> 16) * 100 + HttpResponseDecoder.toDecimal((medium & 0xFF00) >> 8) * 10 + HttpResponseDecoder.toDecimal(medium & 0xFF);
        }
        catch (IllegalCharacterException cause) {
            throw new HttpObjectDecoder.StacklessDecoderException("Invalid start-line: HTTP status-code must contain only 3 digits", cause);
        }
    }

    private static void ensureStatusCodeLength(int length) {
        if (length != 3) {
            throw new DecoderException("Invalid start-line: HTTP status-code must contain only 3 digits but found: " + length + " characters");
        }
    }

    static enum Signal {
        REQUEST_SIGNAL,
        REQUEST_WITH_EXPECT_CONTINUE_SIGNAL;

    }
}

