/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaderValues;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.StreamingHttpResponse;

enum HttpKeepAlive {
    CLOSE_ADD_HEADER(true, true),
    CLOSE_NO_HEADER(true, false),
    KEEP_ALIVE_NO_HEADER(false, false),
    KEEP_ALIVE_ADD_HEADER(false, true);

    private final boolean shouldCloseConnection;
    private final boolean shouldAddConnectionHeader;

    private HttpKeepAlive(boolean shouldCloseConnection, boolean shouldAddConnectionHeader) {
        this.shouldCloseConnection = shouldCloseConnection;
        this.shouldAddConnectionHeader = shouldAddConnectionHeader;
    }

    static HttpKeepAlive responseKeepAlive(HttpMetaData metaData) {
        if (metaData.version().major() >= 2) {
            return KEEP_ALIVE_NO_HEADER;
        }
        if (HttpProtocolVersion.HTTP_1_1.equals(metaData.version())) {
            return metaData.headers().containsIgnoreCase(HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE) ? CLOSE_ADD_HEADER : KEEP_ALIVE_NO_HEADER;
        }
        if (HttpProtocolVersion.HTTP_1_0.equals(metaData.version())) {
            return metaData.headers().containsIgnoreCase(HttpHeaderNames.CONNECTION, HttpHeaderValues.KEEP_ALIVE) ? KEEP_ALIVE_ADD_HEADER : CLOSE_NO_HEADER;
        }
        return CLOSE_NO_HEADER;
    }

    static boolean shouldClose(HttpMetaData metaData) {
        return HttpKeepAlive.responseKeepAlive((HttpMetaData)metaData).shouldCloseConnection;
    }

    void addConnectionHeaderIfNecessary(StreamingHttpResponse response) {
        if (this.shouldAddConnectionHeader) {
            if (this.shouldCloseConnection) {
                response.headers().set(HttpHeaderNames.CONNECTION, HttpHeaderValues.CLOSE);
            } else {
                response.headers().set(HttpHeaderNames.CONNECTION, HttpHeaderValues.KEEP_ALIVE);
            }
        }
    }
}

