/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ServiceDiscoverer;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.client.api.partition.PartitionAttributesBuilder;
import io.servicetalk.client.api.partition.PartitionedServiceDiscovererEvent;
import io.servicetalk.concurrent.api.AsyncCloseables;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.ListenableAsyncCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.api.DelegatingSingleAddressHttpClientBuilder;
import io.servicetalk.http.api.HttpProviders;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.MultiAddressHttpClientBuilder;
import io.servicetalk.http.api.PartitionedHttpClientBuilder;
import io.servicetalk.http.api.SingleAddressHttpClientBuilder;
import io.servicetalk.http.netty.DefaultMultiAddressUrlHttpClientBuilder;
import io.servicetalk.http.netty.DefaultPartitionedHttpClientBuilder;
import io.servicetalk.http.netty.DefaultSingleAddressHttpClientBuilder;
import io.servicetalk.http.netty.GlobalDnsServiceDiscoverer;
import io.servicetalk.http.netty.ResolvingConnectionFactoryFilter;
import io.servicetalk.transport.api.HostAndPort;
import io.servicetalk.utils.internal.ServiceLoaderUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClients {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClients.class);
    private static final List<HttpProviders.SingleAddressHttpClientBuilderProvider> SINGLE_ADDRESS_PROVIDERS;
    private static final List<HttpProviders.MultiAddressHttpClientBuilderProvider> MULTI_ADDRESS_PROVIDERS;
    private static final String UNDEFINED = "undefined";

    private HttpClients() {
    }

    private static <U, R> SingleAddressHttpClientBuilder<U, R> applyProviders(U address, SingleAddressHttpClientBuilder<U, R> builder) {
        for (HttpProviders.SingleAddressHttpClientBuilderProvider provider : SINGLE_ADDRESS_PROVIDERS) {
            builder = provider.newBuilder(address, builder);
        }
        return builder;
    }

    private static <U, R> MultiAddressHttpClientBuilder<U, R> applyProviders(String id, MultiAddressHttpClientBuilder<U, R> builder) {
        if (id.isEmpty()) {
            throw new IllegalArgumentException("ID can not be empty");
        }
        for (HttpProviders.MultiAddressHttpClientBuilderProvider provider : MULTI_ADDRESS_PROVIDERS) {
            builder = provider.newBuilder(id, builder);
        }
        return builder;
    }

    public static MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forMultiAddressUrl() {
        return HttpClients.forMultiAddressUrl(UNDEFINED);
    }

    public static MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forMultiAddressUrl(String id) {
        return HttpClients.applyProviders(id, new DefaultMultiAddressUrlHttpClientBuilder(HttpClients::forSingleAddress));
    }

    public static MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forMultiAddressUrl(String id, DiscoveryStrategy discoveryStrategy) {
        return HttpClients.applyProviders(id, new DefaultMultiAddressUrlHttpClientBuilder(hostAndPort -> HttpClients.forSingleAddress(hostAndPort, discoveryStrategy)));
    }

    @Deprecated
    public static MultiAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forMultiAddressUrl(ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> serviceDiscoverer) {
        return HttpClients.applyProviders(UNDEFINED, new DefaultMultiAddressUrlHttpClientBuilder(address -> HttpClients.forSingleAddress(serviceDiscoverer, address)));
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forSingleAddress(String host, int port) {
        return HttpClients.forSingleAddress(HostAndPort.of(host, port));
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forSingleAddress(HostAndPort address) {
        return HttpClients.forSingleAddress(address, DiscoveryStrategy.BACKGROUND);
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forSingleAddress(String host, int port, DiscoveryStrategy discoveryStrategy) {
        return HttpClients.forSingleAddress(HostAndPort.of(host, port), discoveryStrategy);
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forSingleAddress(HostAndPort address, DiscoveryStrategy discoveryStrategy) {
        return HttpClients.forSingleAddress(GlobalDnsServiceDiscoverer.globalDnsServiceDiscoverer(), address, discoveryStrategy, GlobalDnsServiceDiscoverer::unresolvedServiceDiscoverer, ResolvingConnectionFactoryFilter::withGlobalDnsServiceDiscoverer);
    }

    public static SingleAddressHttpClientBuilder<String, InetSocketAddress> forServiceAddress(String serviceName) {
        ServiceDiscoverer<String, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> sd = GlobalDnsServiceDiscoverer.globalSrvDnsServiceDiscoverer();
        return HttpClients.applyProviders(serviceName, new DefaultSingleAddressHttpClientBuilder<String, InetSocketAddress>(serviceName, sd)).serviceDiscoverer(sd);
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forResolvedAddress(String host, int port) {
        return HttpClients.forResolvedAddress(HostAndPort.of(host, port));
    }

    public static SingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress> forResolvedAddress(HostAndPort address) {
        ServiceDiscoverer<HostAndPort, InetSocketAddress, ServiceDiscovererEvent<InetSocketAddress>> sd = GlobalDnsServiceDiscoverer.resolvedServiceDiscoverer();
        return HttpClients.applyProviders(address, HttpClients.withUnmodifiableServiceDiscoverer(new DefaultSingleAddressHttpClientBuilder<HostAndPort, InetSocketAddress>(address, sd), sd, "resolved address " + address)).serviceDiscoverer(sd).retryServiceDiscoveryErrors(NoRetriesStrategy.INSTANCE);
    }

    public static <R extends SocketAddress> SingleAddressHttpClientBuilder<R, R> forResolvedAddress(R address) {
        ServiceDiscoverer sd = GlobalDnsServiceDiscoverer.mappingServiceDiscoverer(Function.identity(), "identity for " + address.getClass().getSimpleName());
        return HttpClients.applyProviders(address, HttpClients.withUnmodifiableServiceDiscoverer(new DefaultSingleAddressHttpClientBuilder(address, sd), sd, "resolved address " + address)).serviceDiscoverer(sd).retryServiceDiscoveryErrors(NoRetriesStrategy.INSTANCE);
    }

    public static <U, R> SingleAddressHttpClientBuilder<U, R> forSingleAddress(ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>> serviceDiscoverer, U address) {
        return HttpClients.forSingleAddress(serviceDiscoverer, address, DiscoveryStrategy.BACKGROUND);
    }

    public static <U, R> SingleAddressHttpClientBuilder<U, R> forSingleAddress(ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>> serviceDiscoverer, U address, DiscoveryStrategy discoveryStrategy) {
        return HttpClients.forSingleAddress(serviceDiscoverer, address, discoveryStrategy, () -> GlobalDnsServiceDiscoverer.mappingServiceDiscoverer(u -> u, "from " + address.getClass().getSimpleName() + " to an " + Object.class.getSimpleName()), () -> new ResolvingConnectionFactoryFilter<Object, Object>(__ -> address, serviceDiscoverer));
    }

    private static <U, R> SingleAddressHttpClientBuilder<U, R> forSingleAddress(ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>> serviceDiscoverer, U address, DiscoveryStrategy discoveryStrategy, Supplier<ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>>> unresolvedServiceDiscoverer, Supplier<ResolvingConnectionFactoryFilter<U, R>> resolvingConnectionFactory) {
        switch (discoveryStrategy) {
            case BACKGROUND: {
                return HttpClients.applyProviders(address, new DefaultSingleAddressHttpClientBuilder<U, R>(address, serviceDiscoverer)).serviceDiscoverer(serviceDiscoverer);
            }
            case ON_NEW_CONNECTION: {
                ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>> usd = unresolvedServiceDiscoverer.get();
                return HttpClients.applyProviders(address, HttpClients.withUnmodifiableServiceDiscoverer(new DefaultSingleAddressHttpClientBuilder<U, R>(address, usd), usd, address + " with " + discoveryStrategy.name() + " discovery strategy")).serviceDiscoverer(usd).retryServiceDiscoveryErrors(NoRetriesStrategy.INSTANCE).appendConnectionFactoryFilter(resolvingConnectionFactory.get());
            }
        }
        throw new IllegalArgumentException("Unsupported strategy: " + (Object)((Object)discoveryStrategy));
    }

    @Deprecated
    public static <U, R> PartitionedHttpClientBuilder<U, R> forPartitionedAddress(ServiceDiscoverer<U, R, PartitionedServiceDiscovererEvent<R>> serviceDiscoverer, U address, Function<HttpRequestMetaData, PartitionAttributesBuilder> partitionAttributesBuilderFactory) {
        return new DefaultPartitionedHttpClientBuilder(address, () -> HttpClients.forSingleAddress(new ServiceDiscoverer<U, R, ServiceDiscovererEvent<R>>(){
            private final ListenableAsyncCloseable closeable = AsyncCloseables.emptyAsyncCloseable();

            @Override
            public Publisher<Collection<ServiceDiscovererEvent<R>>> discover(U u) {
                return Publisher.failed(new IllegalStateException("Invalid service discoverer."));
            }

            @Override
            public Completable onClose() {
                return this.closeable.onClose();
            }

            @Override
            public Completable onClosing() {
                return this.closeable.onClosing();
            }

            @Override
            public Completable closeAsync() {
                return this.closeable.closeAsync();
            }

            @Override
            public Completable closeAsyncGracefully() {
                return this.closeable.closeAsyncGracefully();
            }
        }, address), serviceDiscoverer, partitionAttributesBuilderFactory);
    }

    private static <U, R> SingleAddressHttpClientBuilder<U, R> withUnmodifiableServiceDiscoverer(SingleAddressHttpClientBuilder<U, R> delegate, final ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>> preConfiguredSd, final String description) {
        return new DelegatingSingleAddressHttpClientBuilder<U, R>(delegate){

            @Override
            public SingleAddressHttpClientBuilder<U, R> serviceDiscoverer(ServiceDiscoverer<U, R, ? extends ServiceDiscovererEvent<R>> serviceDiscoverer) {
                if (serviceDiscoverer != preConfiguredSd) {
                    throw new IllegalArgumentException("Builder for a client for " + description + " doesn't allow changing ServiceDiscoverer to any other instance except the pre-configured " + preConfiguredSd + ", passed argument: " + serviceDiscoverer);
                }
                this.delegate().serviceDiscoverer(serviceDiscoverer);
                return this;
            }
        };
    }

    static {
        ClassLoader classLoader = HttpClients.class.getClassLoader();
        SINGLE_ADDRESS_PROVIDERS = ServiceLoaderUtils.loadProviders(HttpProviders.SingleAddressHttpClientBuilderProvider.class, classLoader, LOGGER);
        MULTI_ADDRESS_PROVIDERS = ServiceLoaderUtils.loadProviders(HttpProviders.MultiAddressHttpClientBuilderProvider.class, classLoader, LOGGER);
    }

    public static enum DiscoveryStrategy {
        BACKGROUND,
        ON_NEW_CONNECTION;

    }

    static final class NoRetriesStrategy
    implements BiIntFunction<Throwable, Completable> {
        static final BiIntFunction<Throwable, Completable> INSTANCE = new NoRetriesStrategy();

        private NoRetriesStrategy() {
        }

        @Override
        public Completable apply(int i, Throwable t) {
            return Completable.failed(t);
        }
    }
}

