/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.AsciiString;
import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.CharSequences;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.ScanMapper;
import io.servicetalk.http.api.EmptyHttpHeaders;
import io.servicetalk.http.api.HttpApiConversions;
import io.servicetalk.http.api.HttpHeaderNames;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpMetaData;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpRequestMetaData;
import io.servicetalk.http.api.HttpRequestMethod;
import io.servicetalk.http.api.HttpResponseStatus;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Predicate;
import javax.annotation.Nullable;

final class HeaderUtils {
    static final Predicate<HttpRequestMetaData> REQ_EXPECT_CONTINUE = reqMetaData -> reqMetaData.version().compareTo(HttpProtocolVersion.HTTP_1_1) >= 0 && reqMetaData.headers().containsIgnoreCase(HttpHeaderNames.EXPECT, io.servicetalk.http.api.HttpHeaderValues.CONTINUE);
    static final Predicate<Object> OBJ_EXPECT_CONTINUE = msg -> {
        if (!(msg instanceof HttpRequestMetaData)) {
            return false;
        }
        return REQ_EXPECT_CONTINUE.test((HttpRequestMetaData)msg);
    };

    private HeaderUtils() {
    }

    static int indexOf(CharSequence sequence, char c, int fromIndex) {
        return sequence instanceof AsciiString ? ((AsciiString)sequence).indexOf(c, fromIndex) : CharSequences.indexOf(sequence, c, fromIndex);
    }

    static void removeTransferEncodingChunked(HttpHeaders headers) {
        Iterator<? extends CharSequence> itr = headers.valuesIterator(HttpHeaderNames.TRANSFER_ENCODING);
        while (itr.hasNext()) {
            if (!HttpHeaderValues.CHUNKED.contentEqualsIgnoreCase(itr.next())) continue;
            itr.remove();
        }
    }

    static boolean canAddRequestContentLength(StreamingHttpRequest request) {
        return HeaderUtils.canAddContentLength(request) && HeaderUtils.clientMaySendPayloadBodyFor(request.method());
    }

    static boolean canAddResponseContentLength(StreamingHttpResponse response, HttpRequestMethod requestMethod) {
        return HeaderUtils.canAddContentLength(response) && HeaderUtils.serverMaySendPayloadBodyFor(response.status().code(), requestMethod);
    }

    static boolean clientMaySendPayloadBodyFor(HttpRequestMethod requestMethod) {
        return !HttpRequestMethod.TRACE.equals(requestMethod);
    }

    static boolean serverMaySendPayloadBodyFor(int statusCode, HttpRequestMethod requestMethod) {
        return !HttpRequestMethod.HEAD.equals(requestMethod) && !HeaderUtils.isEmptyResponseStatus(statusCode) && !HeaderUtils.isEmptyConnectResponse(requestMethod, statusCode);
    }

    private static boolean canAddContentLength(HttpMetaData metadata) {
        return !(!HttpApiConversions.isPayloadEmpty(metadata) && !HttpApiConversions.isSafeToAggregate(metadata) || metadata.version().major() <= 1 && HttpApiConversions.mayHaveTrailers(metadata) || HeaderUtils.hasContentHeaders(metadata.headers()));
    }

    private static boolean alwaysAppendTrailers(HttpProtocolVersion protocolVersion) {
        return protocolVersion.major() > 1;
    }

    static boolean shouldAppendTrailers(HttpProtocolVersion protocolVersion, HttpMetaData metaData) {
        return HeaderUtils.alwaysAppendTrailers(protocolVersion) || HeaderUtils.chunkedSupported(protocolVersion) && (HttpApiConversions.mayHaveTrailers(metaData) || !metaData.headers().contains(HttpHeaderNames.CONTENT_LENGTH));
    }

    static Publisher<Object> setRequestContentLength(HttpProtocolVersion protocolVersion, StreamingHttpRequest request) {
        return HeaderUtils.setContentLength(request, request.messageBody(), HeaderUtils.shouldAddZeroContentLength(request.method()) ? HeaderUtils::updateContentLength : HeaderUtils::updateRequestContentLengthNonZero, protocolVersion, false);
    }

    static Publisher<Object> setResponseContentLength(HttpProtocolVersion protocolVersion, StreamingHttpResponse response) {
        return HeaderUtils.setContentLength(response, response.messageBody(), HeaderUtils::updateContentLength, protocolVersion, true);
    }

    private static void updateRequestContentLengthNonZero(int contentLength, HttpHeaders headers) {
        if (contentLength > 0) {
            headers.set(HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(contentLength));
        }
    }

    private static void updateContentLength(int contentLength, HttpHeaders headers) {
        assert (contentLength >= 0);
        headers.set(HttpHeaderNames.CONTENT_LENGTH, contentLength == 0 ? io.servicetalk.http.api.HttpHeaderValues.ZERO : Integer.toString(contentLength));
    }

    static boolean shouldAddZeroContentLength(HttpRequestMethod requestMethod) {
        return HttpRequestMethod.POST.equals(requestMethod) || HttpRequestMethod.PUT.equals(requestMethod) || HttpRequestMethod.PATCH.equals(requestMethod);
    }

    static boolean responseMayHaveContent(int statusCode, HttpRequestMethod requestMethod) {
        return !HeaderUtils.isEmptyResponseStatus(statusCode) && !HeaderUtils.isEmptyConnectResponse(requestMethod, statusCode);
    }

    static ScanMapper<Object, Object> appendTrailersMapper() {
        return new ScanMapper<Object, Object>(){
            private boolean sawHeaders;

            @Override
            @Nullable
            public Object mapOnNext(@Nullable Object next) {
                if (next instanceof HttpHeaders) {
                    this.sawHeaders = true;
                }
                return next;
            }

            @Override
            @Nullable
            public ScanMapper.MappedTerminal<Object> mapOnError(Throwable cause) throws Throwable {
                throw cause;
            }

            @Override
            @Nullable
            public ScanMapper.MappedTerminal<Object> mapOnComplete() {
                return this.sawHeaders ? null : EmptyHeadersComplete.INSTANCE;
            }
        };
    }

    static boolean emptyMessageBody(HttpMetaData metadata, Publisher<Object> messageBody) {
        return messageBody == Publisher.empty() || HeaderUtils.emptyMessageBody(metadata);
    }

    static boolean emptyMessageBody(HttpMetaData metadata) {
        return HttpApiConversions.isPayloadEmpty(metadata) && !HttpApiConversions.mayHaveTrailers(metadata);
    }

    static Publisher<Object> flatEmptyMessage(HttpProtocolVersion protocolVersion, HttpMetaData metadata, Publisher<Object> messageBody, boolean propagateCancel) {
        Publisher<Object> flatMessage;
        assert (HeaderUtils.emptyMessageBody(metadata, messageBody));
        Publisher<Object> publisher = flatMessage = protocolVersion.major() > 1 || !HeaderUtils.shouldAppendTrailers(protocolVersion, metadata) ? Publisher.from(metadata) : Publisher.from(metadata, EmptyHttpHeaders.INSTANCE);
        if (messageBody == Publisher.empty()) {
            return flatMessage;
        }
        return propagateCancel ? flatMessage.concatPropagateCancel(messageBody.ignoreElements()) : flatMessage.concat(messageBody.ignoreElements());
    }

    private static Publisher<Object> setContentLength(HttpMetaData metadata, Publisher<Object> messageBody, BiIntConsumer<HttpHeaders> contentLengthUpdater, HttpProtocolVersion protocolVersion, boolean propagateCancel) {
        if (HeaderUtils.emptyMessageBody(metadata, messageBody)) {
            contentLengthUpdater.apply(0, metadata.headers());
            return HeaderUtils.flatEmptyMessage(protocolVersion, metadata, messageBody, propagateCancel);
        }
        return messageBody.collect(() -> null, (reduction, item) -> {
            ContentLengthList items;
            if (reduction == null) {
                return item;
            }
            if (reduction instanceof ContentLengthList) {
                ContentLengthList itemsUnchecked;
                items = itemsUnchecked = (ContentLengthList)reduction;
            } else {
                items = new ContentLengthList(reduction instanceof Buffer ? ((Buffer)reduction).readableBytes() : 0, 2);
                items.add(reduction);
            }
            if (item instanceof Buffer) {
                items.contentLength += ((Buffer)item).readableBytes();
            }
            items.add(item);
            return items;
        }).flatMapPublisher(reduction -> {
            Publisher<Object> flatRequest;
            int contentLength = 0;
            boolean appendTrailers = HeaderUtils.alwaysAppendTrailers(protocolVersion);
            if (reduction == null) {
                flatRequest = appendTrailers ? Publisher.from(metadata, EmptyHttpHeaders.INSTANCE) : Publisher.from(metadata);
            } else if (reduction instanceof Buffer) {
                Buffer buffer = (Buffer)reduction;
                contentLength = buffer.readableBytes();
                flatRequest = contentLength == 0 ? (appendTrailers ? Publisher.from(metadata, EmptyHttpHeaders.INSTANCE) : Publisher.from(metadata)) : (appendTrailers ? Publisher.from(metadata, buffer, EmptyHttpHeaders.INSTANCE) : Publisher.from(metadata, buffer));
            } else if (reduction instanceof ContentLengthList) {
                ContentLengthList items = (ContentLengthList)reduction;
                contentLength = items.contentLength;
                if (appendTrailers && !(items.get(items.size() - 1) instanceof HttpHeaders)) {
                    items.add(EmptyHttpHeaders.INSTANCE);
                }
                flatRequest = Publisher.from(metadata).concat(Publisher.fromIterable(items));
            } else if (reduction instanceof HttpHeaders) {
                flatRequest = Publisher.from(metadata, reduction);
            } else {
                throw new IllegalArgumentException("unsupported payload chunk type: " + reduction);
            }
            contentLengthUpdater.apply(contentLength, metadata.headers());
            return flatRequest;
        });
    }

    static void addResponseTransferEncodingIfNecessary(StreamingHttpResponse response, HttpRequestMethod requestMethod) {
        if (HeaderUtils.serverMaySendPayloadBodyFor(response.status().code(), requestMethod) && HeaderUtils.canAddTransferEncodingChunked(response)) {
            response.headers().add(HttpHeaderNames.TRANSFER_ENCODING, io.servicetalk.http.api.HttpHeaderValues.CHUNKED);
        }
    }

    static void addRequestTransferEncodingIfNecessary(StreamingHttpRequest request) {
        if (HeaderUtils.clientMaySendPayloadBodyFor(request.method()) && HeaderUtils.canAddTransferEncodingChunked(request)) {
            request.headers().add(HttpHeaderNames.TRANSFER_ENCODING, io.servicetalk.http.api.HttpHeaderValues.CHUNKED);
        }
    }

    private static boolean canAddTransferEncodingChunked(HttpMetaData metaData) {
        HttpHeaders headers = metaData.headers();
        return HeaderUtils.chunkedSupported(metaData.version()) && (HttpApiConversions.mayHaveTrailers(metaData) || !headers.contains(HttpHeaderNames.CONTENT_LENGTH)) && !io.servicetalk.http.api.HeaderUtils.isTransferEncodingChunked(headers);
    }

    private static boolean chunkedSupported(HttpProtocolVersion version) {
        return version.major() == 1 && version.minor() > 0;
    }

    static boolean hasContentHeaders(HttpHeaders headers) {
        return headers.contains(HttpHeaderNames.CONTENT_LENGTH) || io.servicetalk.http.api.HeaderUtils.isTransferEncodingChunked(headers);
    }

    private static boolean isEmptyConnectResponse(HttpRequestMethod requestMethod, int statusCode) {
        return HttpRequestMethod.CONNECT.equals(requestMethod) && HttpResponseStatus.StatusClass.SUCCESSFUL_2XX.contains(statusCode);
    }

    private static boolean isEmptyResponseStatus(int statusCode) {
        return HttpResponseStatus.StatusClass.INFORMATIONAL_1XX.contains(statusCode) || statusCode == HttpResponseStatus.NO_CONTENT.code();
    }

    static long contentLength(Iterator<? extends CharSequence> iterator) {
        long value;
        if (!iterator.hasNext()) {
            return -1L;
        }
        CharSequence firstValue = iterator.next();
        if (iterator.hasNext()) {
            throw HeaderUtils.multipleCL(firstValue, iterator);
        }
        char firstChar = firstValue.charAt(0);
        if (firstChar < '0' || firstChar > '9') {
            throw HeaderUtils.malformedCL(firstValue);
        }
        try {
            value = CharSequences.parseLong(firstValue);
        }
        catch (NumberFormatException e) {
            if (CharSequences.indexOf(firstValue, ',', 0) >= 0) {
                throw HeaderUtils.multipleCL(firstValue, null);
            }
            throw HeaderUtils.malformedCL(firstValue);
        }
        return value;
    }

    private static IllegalArgumentException malformedCL(CharSequence value) {
        return new IllegalArgumentException("Malformed 'content-length' value: " + value);
    }

    private static IllegalArgumentException multipleCL(CharSequence firstValue, @Nullable Iterator<? extends CharSequence> iterator) {
        CharSequence allClValues;
        if (iterator == null) {
            allClValues = firstValue;
        } else {
            StringBuilder sb = new StringBuilder(firstValue.length() + 8).append(firstValue);
            while (iterator.hasNext()) {
                sb.append(", ").append(iterator.next());
            }
            allClValues = sb;
        }
        return new IllegalArgumentException("Multiple content-length values found: " + allClValues);
    }

    @FunctionalInterface
    private static interface BiIntConsumer<T> {
        public void apply(int var1, T var2);
    }

    private static final class ContentLengthList<T>
    extends ArrayList<T> {
        int contentLength;

        ContentLengthList(int contentLength, int arraySize) {
            super(arraySize);
            this.contentLength = contentLength;
        }

        @Override
        public int hashCode() {
            return 31 * this.contentLength + super.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ContentLengthList && ((ContentLengthList)o).contentLength == this.contentLength && super.equals(o);
        }
    }

    private static final class EmptyHeadersComplete
    implements ScanMapper.MappedTerminal<Object> {
        private static final ScanMapper.MappedTerminal<Object> INSTANCE = new EmptyHeadersComplete();

        private EmptyHeadersComplete() {
        }

        @Override
        public HttpHeaders onNext() {
            return EmptyHttpHeaders.INSTANCE;
        }

        @Override
        public boolean onNextValid() {
            return true;
        }

        @Override
        @Nullable
        public Throwable terminal() {
            return null;
        }
    }
}

